/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.ConstantTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.AddPropertyStepContract;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.SideEffectStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.Parameters;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.CallbackRegistry;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.Event;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.EventUtil;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.ListCallbackRegistry;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.EventStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.structure.util.keyed.KeyedProperty;
import org.apache.tinkerpop.gremlin.structure.util.keyed.KeyedVertexProperty;

public class AddPropertyStep<S extends Element>
extends SideEffectStep<S>
implements AddPropertyStepContract<S> {
    private Parameters internalParameters = new Parameters();
    private Parameters withConfiguration = new Parameters();
    private final VertexProperty.Cardinality cardinality;
    private CallbackRegistry<Event.ElementPropertyChangedEvent> callbackRegistry;

    public AddPropertyStep(Traversal.Admin traversal, VertexProperty.Cardinality cardinality, Object keyObject, Object valueObject) {
        super(traversal);
        this.internalParameters.set(this, T.key, keyObject, T.value, valueObject);
        this.cardinality = cardinality;
    }

    @Override
    public Parameters getParameters() {
        return this.withConfiguration;
    }

    @Override
    public Set<String> getScopeKeys() {
        return this.internalParameters.getReferencedLabels();
    }

    @Override
    public <S, E> List<Traversal.Admin<S, E>> getLocalChildren() {
        return this.internalParameters.getTraversals();
    }

    @Override
    public void configure(Object ... keyValues) {
        this.withConfiguration.set(this, keyValues);
    }

    @Override
    protected void sideEffect(Traverser.Admin<S> traverser) {
        VertexProperty.Cardinality card;
        Object k = this.internalParameters.get(traverser, T.key, () -> {
            throw new IllegalStateException("The AddPropertyStep does not have a provided key: " + this);
        }).get(0);
        if (k instanceof T) {
            throw new IllegalStateException(String.format("T.%s is immutable on existing elements", ((T)k).name()));
        }
        String key = (String)k;
        Object value = this.internalParameters.get(traverser, T.value, () -> {
            throw new IllegalStateException("The AddPropertyStep does not have a provided value: " + this);
        }).get(0);
        Object[] vertexPropertyKeyValues = this.internalParameters.getKeyValues(traverser, T.key, T.value);
        Element element = (Element)traverser.get();
        if (this.cardinality != null && !(element instanceof Vertex)) {
            throw new IllegalStateException(String.format("Property cardinality can only be set for a Vertex but the traversal encountered %s for key: %s", element.getClass().getSimpleName(), key));
        }
        Optional<EventStrategy> optEventStrategy = this.getTraversal().getStrategies().getStrategy(EventStrategy.class);
        boolean eventingIsConfigured = EventUtil.hasAnyCallbacks(this.callbackRegistry) && optEventStrategy.isPresent();
        EventStrategy es = optEventStrategy.orElse(null);
        VertexProperty removedProperty = eventingIsConfigured ? this.captureRemovedProperty(element, key, value, es) : VertexProperty.empty();
        VertexProperty.Cardinality cardinality = card = this.cardinality != null ? this.cardinality : element.graph().features().vertex().getCardinality(key);
        if (element instanceof Vertex) {
            if (null != card) {
                ((Vertex)element).property(card, key, value, vertexPropertyKeyValues);
            } else if (vertexPropertyKeyValues.length > 0) {
                ((Vertex)element).property(key, value, vertexPropertyKeyValues);
            } else {
                ((Vertex)element).property(key, value);
            }
        } else if (element instanceof Edge) {
            element.property(key, value);
        } else if (element instanceof VertexProperty) {
            element.property(key, value);
        }
        if (eventingIsConfigured) {
            EventUtil.registerPropertyChange(this.callbackRegistry, es, element, removedProperty, value, vertexPropertyKeyValues);
        }
    }

    private Property captureRemovedProperty(Element element, String key, Object value, EventStrategy es) {
        Property removedProperty = VertexProperty.empty();
        if (element instanceof Vertex) {
            if (this.cardinality == VertexProperty.Cardinality.set) {
                Iterator properties = element.properties(key);
                while (properties.hasNext()) {
                    Property property = properties.next();
                    if (!Objects.equals(property.value(), value)) continue;
                    removedProperty = property;
                    break;
                }
            } else if (this.cardinality == VertexProperty.Cardinality.single) {
                removedProperty = element.property(key);
            }
        } else {
            removedProperty = element.property(key);
        }
        removedProperty = removedProperty.isPresent() ? es.detach(removedProperty) : (element instanceof Vertex ? new KeyedVertexProperty(key) : new KeyedProperty(key));
        return removedProperty;
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return this.getSelfAndChildRequirements(TraverserRequirement.OBJECT);
    }

    @Override
    public CallbackRegistry<Event.ElementPropertyChangedEvent> getMutatingCallbackRegistry() {
        if (null == this.callbackRegistry) {
            this.callbackRegistry = new ListCallbackRegistry<Event.ElementPropertyChangedEvent>();
        }
        return this.callbackRegistry;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode() ^ this.internalParameters.hashCode() ^ this.withConfiguration.hashCode();
        return null != this.cardinality ? hash ^ this.cardinality.hashCode() : hash;
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        this.internalParameters.getTraversals().forEach(this::integrateChild);
        this.withConfiguration.getTraversals().forEach(this::integrateChild);
    }

    @Override
    public VertexProperty.Cardinality getCardinality() {
        return this.cardinality;
    }

    @Override
    public Object getKey() {
        List keyParams = this.internalParameters.get(T.key, null);
        return keyParams.isEmpty() ? null : keyParams.get(0);
    }

    @Override
    public Object getValue() {
        List values = this.internalParameters.get(T.value, null);
        if (values.isEmpty()) {
            return null;
        }
        return values.get(0) instanceof ConstantTraversal ? ((ConstantTraversal)values.get(0)).next() : values.get(0);
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.internalParameters);
    }

    @Override
    public AddPropertyStep<S> clone() {
        AddPropertyStep clone = (AddPropertyStep)super.clone();
        clone.internalParameters = this.internalParameters.clone();
        clone.withConfiguration = this.withConfiguration.clone();
        return clone;
    }

    @Override
    public void addProperty(Object key, Object value) {
        this.internalParameters.set(this, key, value);
    }

    @Override
    public Map<Object, List<Object>> getProperties() {
        return this.internalParameters.getRaw(T.key, T.value);
    }

    @Override
    public boolean removeProperty(Object k) {
        if (this.internalParameters.contains(k)) {
            this.internalParameters.remove(k);
            return true;
        }
        return false;
    }
}

