/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.eval.app.tools;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LeipzigHelper {
    static Map<String, List<Path>> getFiles(Path leipzigDir) throws IOException {
        Matcher tableMatcher = Pattern.compile("([a-z]+)_table(\\.txt)?(\\.gz)?$").matcher("");
        Matcher leipzigMatcher = Pattern.compile("([a-z]{3,3}(-(simp|trad|rom|zaw))?)[-_].*$").matcher("");
        TreeMap<String, List<Path>> m = new TreeMap<String, List<Path>>();
        for (File f : leipzigDir.toFile().listFiles()) {
            System.err.println(f);
            String lang = null;
            if (tableMatcher.reset(f.getName()).find()) {
                lang = tableMatcher.group(1);
            } else if (leipzigMatcher.reset(f.getName()).find()) {
                lang = leipzigMatcher.group(1);
            }
            if (lang == null) {
                System.err.println("couldn't find a lang: " + String.valueOf(f));
                continue;
            }
            ArrayList<Path> files = (ArrayList<Path>)m.get(lang);
            if (files == null) {
                files = new ArrayList<Path>();
            }
            files.add(f.toPath());
            m.put(lang, files);
        }
        return m;
    }
}

