/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.dwg;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Map;
import org.apache.tika.config.Param;
import org.apache.tika.exception.TikaConfigException;
import org.apache.tika.parser.external.ExternalParser;
import org.apache.tika.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DWGParserConfig
implements Serializable {
    private static final long serialVersionUID = -7623524257255755725L;
    private String dwgReadExecutable = "";
    private boolean cleanDwgReadOutput = true;
    private int cleanDwgReadOutputBatchSize = 10000000;
    private long dwgReadTimeout = 300000L;
    private String cleanDwgReadRegexToReplace = "[^\\x20-\\x7e]";
    private String cleanDwgReadReplaceWith = "";
    private boolean hasDwgRead;
    private static final Logger LOG = LoggerFactory.getLogger(DWGParserConfig.class);

    public void initialize(Map<String, Param> params) throws TikaConfigException {
        this.hasDwgRead = this.hasDwgRead();
    }

    public boolean hasDwgRead() throws TikaConfigException {
        String dwgRead = this.getDwgReadExecutable();
        if (!StringUtils.isBlank(dwgRead) && !Files.isRegularFile(Paths.get(dwgRead, new String[0]), new LinkOption[0])) {
            throw new TikaConfigException("DwgRead cannot be found at: " + dwgRead);
        }
        Object[] checkCmd = new String[]{dwgRead};
        boolean hasDwgRead = ExternalParser.check((String[])checkCmd, new int[0]);
        LOG.debug("hasDwgRead (path: " + Arrays.toString(checkCmd) + "): " + hasDwgRead);
        return hasDwgRead;
    }

    public String getDwgReadExecutable() {
        return this.dwgReadExecutable;
    }

    public boolean isCleanDwgReadOutput() {
        return this.cleanDwgReadOutput;
    }

    public int getCleanDwgReadOutputBatchSize() {
        return this.cleanDwgReadOutputBatchSize;
    }

    public long getDwgReadTimeout() {
        return this.dwgReadTimeout;
    }

    public String getCleanDwgReadRegexToReplace() {
        return this.cleanDwgReadRegexToReplace;
    }

    public String getCleanDwgReadReplaceWith() {
        return this.cleanDwgReadReplaceWith;
    }

    public void setDwgReadExecutable(String dwgReadExecutable) {
        if (!Paths.get(dwgReadExecutable, new String[0]).isAbsolute()) {
            try {
                dwgReadExecutable = new File(dwgReadExecutable).getCanonicalFile().toString();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.dwgReadExecutable = dwgReadExecutable;
    }

    public void setCleanDwgReadOutput(boolean cleanDwgReadOutput) {
        this.cleanDwgReadOutput = cleanDwgReadOutput;
    }

    public void setCleanDwgReadOutputBatchSize(int cleanDwgReadOutputBatchSize) {
        this.cleanDwgReadOutputBatchSize = cleanDwgReadOutputBatchSize;
    }

    public void setDwgReadtimeout(long dwgReadtimeout) {
        this.dwgReadTimeout = dwgReadtimeout;
    }

    public void setCleanDwgReadRegexToReplace(String cleanDwgReadRegexToReplace) {
        this.cleanDwgReadRegexToReplace = cleanDwgReadRegexToReplace;
    }

    public void setCleanDwgReadReplaceWith(String cleanDwgReadReplaceWith) {
        this.cleanDwgReadReplaceWith = cleanDwgReadReplaceWith;
    }
}

