/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.sling.testing.mock.osgi.MockOsgi;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class MockServiceReferenceTest {
    private BundleContext bundleContext;
    private ServiceReference serviceReference;
    private Object service;

    @Before
    public void setUp() {
        this.bundleContext = MockOsgi.newBundleContext();
        this.service = new Object();
        String clazz = String.class.getName();
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("customProp1", "value1");
        this.bundleContext.registerService(clazz, this.service, props);
        this.serviceReference = this.bundleContext.getServiceReference(clazz);
    }

    @Test
    public void testBundle() {
        Assert.assertSame((Object)this.bundleContext.getBundle(), (Object)this.serviceReference.getBundle());
    }

    @Test
    public void testServiceId() {
        Assert.assertNotNull((Object)this.serviceReference.getProperty("service.id"));
    }

    @Test
    public void testProperties() {
        Assert.assertEquals((long)3L, (long)this.serviceReference.getPropertyKeys().length);
        Assert.assertEquals((Object)"value1", (Object)this.serviceReference.getProperty("customProp1"));
        Assert.assertNotNull((Object)this.serviceReference.getProperty("service.id"));
        Assert.assertArrayEquals((Object[])((String[])this.serviceReference.getProperty("objectClass")), (Object[])new String[]{String.class.getName()});
        Assert.assertEquals((long)3L, (long)this.serviceReference.getProperties().size());
        Assert.assertEquals((Object)"value1", this.serviceReference.getProperties().get("customProp1"));
    }
}

