/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resource.filter.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.resource.filter.impl.Context;
import org.apache.sling.resource.filter.impl.Visitor;

public class DefaultContext
implements Context {
    private Map<String, BiFunction<Object[], Resource, Object>> functions = new HashMap<String, BiFunction<Object[], Resource, Object>>();
    private Map<String, Object> parameters = new HashMap<String, Object>();
    private Visitor<Predicate<Resource>> logicVisitor;
    private Visitor<Function<Resource, Object>> comparisonVisitor;

    @Override
    public Context addFunction(String name, BiFunction<Object[], Resource, Object> functionImpl) {
        this.functions.put(name, functionImpl);
        return this;
    }

    @Override
    public Context removeFunction(String name) {
        this.functions.remove(name);
        return this;
    }

    @Override
    public Context addParameter(String name, Object object) {
        this.parameters.put(name, object);
        return this;
    }

    @Override
    public Visitor<Predicate<Resource>> getLogicVisitor() {
        return this.logicVisitor;
    }

    @Override
    public Visitor<Function<Resource, Object>> getComparisonVisitor() {
        return this.comparisonVisitor;
    }

    @Override
    public void setLogicVisitor(Visitor<Predicate<Resource>> logicVisitor) {
        this.logicVisitor = logicVisitor;
    }

    @Override
    public void setComparionVisitor(Visitor<Function<Resource, Object>> comparisonVisitor) {
        this.comparisonVisitor = comparisonVisitor;
    }

    @Override
    public Optional<BiFunction<Object[], Resource, Object>> getFunction(String text) {
        return Optional.ofNullable(this.functions.get(text));
    }

    @Override
    public Optional<Object> getParameter(String text) {
        return Optional.ofNullable(this.parameters.get(text));
    }

    @Override
    public void addParameters(Map<String, Object> params) {
        this.parameters.putAll(params);
    }

    @Override
    public Context replaceParameterMap(Map<String, Object> params) {
        this.parameters = params;
        return this;
    }
}

