/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.util.Objects;
import java.util.Set;
import org.apache.sis.image.ComputedImage;
import org.apache.sis.image.PlanarImage;
import org.apache.sis.image.internal.shared.ImageUtilities;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Disposable;

abstract class SourceAlignedImage
extends ComputedImage {
    static final Set<String> POSITIONAL_PROPERTIES = Set.of("org.apache.sis.XYDimensions", "org.apache.sis.GridGeometry", "org.apache.sis.PositionalAccuracy", "org.apache.sis.PositionalConsistency");
    private final ColorModel colorModel;

    protected SourceAlignedImage(RenderedImage source) {
        super(SourceAlignedImage.getSampleModel(source), source);
        this.colorModel = source.getColorModel();
    }

    private static SampleModel getSampleModel(RenderedImage source) {
        SampleModel sm = source.getSampleModel();
        int width = source.getTileWidth();
        int height = source.getTileHeight();
        if (sm.getWidth() == width && sm.getHeight() == height) {
            return sm;
        }
        return sm.createCompatibleSampleModel(width, height);
    }

    SourceAlignedImage(RenderedImage source, ColorModel colorModel, SampleModel sampleModel) {
        super(sampleModel, source);
        this.colorModel = colorModel;
        assert (source.getSampleModel().getWidth() == sampleModel.getWidth() && source.getSampleModel().getHeight() == sampleModel.getHeight());
    }

    protected SourceAlignedImage(RenderedImage source, ColorModel colorModel) {
        super(SourceAlignedImage.createSampleModel(colorModel, source.getSampleModel()), source);
        this.colorModel = colorModel;
    }

    private static SampleModel createSampleModel(ColorModel colorModel, SampleModel original) {
        SampleModel sm = colorModel.createCompatibleSampleModel(original.getWidth(), original.getHeight());
        return original.equals(sm) ? original : sm;
    }

    @Override
    public final ColorModel getColorModel() {
        return this.colorModel;
    }

    static String[] filterPropertyNames(String[] names, Set<String> inherit, String[] append) {
        if (names == null) {
            return append != null ? (String[])append.clone() : null;
        }
        int n = 0;
        for (String name : names) {
            if (!inherit.contains(name)) continue;
            names[n++] = name;
        }
        if (append == null) {
            return (String[])ArraysExt.resize((Object[])names, (int)n);
        }
        names = (String[])ArraysExt.resize((Object[])names, (int)(n + append.length));
        System.arraycopy(names, n, append, 0, append.length);
        return names;
    }

    @Override
    public Shape getValidArea() {
        return ImageUtilities.getValidArea(this.getSource());
    }

    @Override
    public final int getMinX() {
        return this.getSource().getMinX();
    }

    @Override
    public final int getMinY() {
        return this.getSource().getMinY();
    }

    @Override
    public final int getWidth() {
        return this.getSource().getWidth();
    }

    @Override
    public final int getHeight() {
        return this.getSource().getHeight();
    }

    @Override
    public final int getMinTileX() {
        return this.getSource().getMinTileX();
    }

    @Override
    public final int getMinTileY() {
        return this.getSource().getMinTileY();
    }

    @Override
    public final int getNumXTiles() {
        return this.getSource().getNumXTiles();
    }

    @Override
    public final int getNumYTiles() {
        return this.getSource().getNumYTiles();
    }

    @Override
    public final int getTileGridXOffset() {
        return this.getSource().getTileGridXOffset();
    }

    @Override
    public final int getTileGridYOffset() {
        return this.getSource().getTileGridYOffset();
    }

    @Override
    protected Disposable prefetch(Rectangle tiles) {
        RenderedImage source = this.getSource();
        if (source instanceof PlanarImage) {
            return ((PlanarImage)source).prefetch(tiles);
        }
        return super.prefetch(tiles);
    }

    public int hashCode() {
        return this.hashCodeBase() + 37 * Objects.hashCode(this.colorModel);
    }

    public boolean equals(Object object) {
        if (this.equalsBase(object)) {
            SourceAlignedImage other = (SourceAlignedImage)object;
            return Objects.equals(this.colorModel, other.colorModel);
        }
        return false;
    }
}

