/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter.math;

import java.io.ObjectStreamException;
import java.util.Objects;
import java.util.function.DoublePredicate;
import org.apache.sis.feature.internal.shared.FeatureExpression;
import org.apache.sis.feature.internal.shared.FeatureProjectionBuilder;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.Optimization;
import org.apache.sis.filter.base.UnaryFunction;
import org.apache.sis.filter.math.Function;
import org.opengis.util.ScopedName;

final class Predicate<R>
extends UnaryFunction<R, Number>
implements FeatureExpression<R, Boolean>,
Optimization.OnExpression<R, Boolean> {
    private static final long serialVersionUID = -5550022435116093162L;
    private final Function function;
    private final transient DoublePredicate math;

    Predicate(Function function, Expression<R, ? extends Number> expression) {
        super(expression);
        this.function = function;
        this.math = Objects.requireNonNull(function.filter);
    }

    private Object readResolve() throws ObjectStreamException {
        return new Predicate<R>(this.function, this.expression);
    }

    @Override
    public ScopedName getFunctionName() {
        return this.function.getFunctionName();
    }

    @Override
    public final Class<Boolean> getResultClass() {
        return Boolean.class;
    }

    @Override
    public final FeatureProjectionBuilder.Item expectedType(FeatureProjectionBuilder addTo) {
        return addTo.addSourceProperty(this.function.getResultType(), false);
    }

    @Override
    public final Boolean apply(R feature) {
        Number value = (Number)this.expression.apply(feature);
        if (value != null) {
            return this.math.test(value.doubleValue());
        }
        return null;
    }
}

