/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.coverage;

import java.awt.Color;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import org.apache.sis.coverage.Category;
import org.apache.sis.gui.controls.ColorColumnHandler;
import org.apache.sis.gui.controls.ColorRamp;
import org.apache.sis.gui.coverage.CoverageCanvas;
import org.apache.sis.gui.internal.ImmutableObjectProperty;
import org.apache.sis.gui.internal.Resources;
import org.apache.sis.image.Colorizer;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.util.InternationalString;

final class CoverageStyling
extends ColorColumnHandler<Category>
implements Function<Category, Color[]>,
ChangeListener<ColorRamp> {
    private final Map<String, SimpleObjectProperty<ColorRamp>> customizedColors = new HashMap<String, SimpleObjectProperty<ColorRamp>>();
    private final CoverageCanvas canvas;

    CoverageStyling(CoverageCanvas canvas) {
        this.canvas = canvas;
        if (canvas != null) {
            canvas.setColorizer(Colorizer.forCategories((Function)this));
        }
    }

    final void copyStyling(CoverageStyling source) {
        for (Map.Entry<String, SimpleObjectProperty<ColorRamp>> entry : source.customizedColors.entrySet()) {
            SimpleObjectProperty property = new SimpleObjectProperty((Object)((ColorRamp)entry.getValue().getValue()));
            this.customizedColors.put(entry.getKey(), (SimpleObjectProperty<ColorRamp>)property);
            property.addListener((ChangeListener)this);
        }
        if (this.canvas != null) {
            this.canvas.stylingChanged();
        }
    }

    private void clear(ObservableList<Category> items) {
        Object[] content = (Category[])items.toArray(Category[]::new);
        items.clear();
        this.customizedColors.clear();
        items.setAll(content);
        if (this.canvas != null) {
            this.canvas.stylingChanged();
        }
    }

    private static String key(Category category) {
        return category.getName().toString(Locale.ROOT);
    }

    protected SimpleObjectProperty<ColorRamp> getObservableValue(Category category) {
        return this.customizedColors.computeIfAbsent(CoverageStyling.key(category), key -> {
            SimpleObjectProperty property = new SimpleObjectProperty();
            if (category.isQuantitative()) {
                property.setValue((Object)ColorRamp.DEFAULT);
            }
            property.addListener((ChangeListener)this);
            return property;
        });
    }

    public void changed(ObservableValue<? extends ColorRamp> property, ColorRamp old, ColorRamp colors) {
        if (this.canvas != null && !Objects.equals(colors, old)) {
            this.canvas.stylingChanged();
        }
    }

    @Override
    public Color[] apply(Category category) {
        int[] ARGB;
        ColorRamp ramp;
        SimpleObjectProperty<ColorRamp> property = this.customizedColors.get(CoverageStyling.key(category));
        if (property != null && (ramp = (ColorRamp)property.getValue()) != null && (ARGB = ramp.colors) != null) {
            Color[] colors = new Color[ARGB.length];
            for (int i = 0; i < colors.length; ++i) {
                colors[i] = new Color(ARGB[i], true);
            }
            return colors;
        }
        return null;
    }

    @Override
    protected ColorRamp.Type applyColors(Category category, ColorRamp colors) {
        if (colors != null) {
            SimpleObjectProperty<ColorRamp> property = this.getObservableValue(category);
            property.setValue((Object)colors);
        } else {
            SimpleObjectProperty<ColorRamp> property = this.customizedColors.get(CoverageStyling.key(category));
            if (property != null) {
                property.setValue((Object)(category.isQuantitative() ? ColorRamp.DEFAULT : null));
            }
        }
        return category.isQuantitative() ? ColorRamp.Type.GRADIENT : ColorRamp.Type.SOLID;
    }

    final TableView<Category> createCategoryTable(Resources resources, Vocabulary vocabulary) {
        TableColumn name = new TableColumn(vocabulary.getString((short)139));
        name.setCellValueFactory(CoverageStyling::getCategoryName);
        name.setCellFactory(CoverageStyling::createNameCell);
        name.setEditable(false);
        name.setId("name");
        TableView table = new TableView();
        table.getColumns().add((Object)name);
        table.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY_FLEX_LAST_COLUMN);
        this.addColumnTo(table, vocabulary.getString((short)228));
        MenuItem reset = new MenuItem(resources.getString((short)55));
        reset.setOnAction(e -> this.clear((ObservableList<Category>)table.getItems()));
        table.setContextMenu(new ContextMenu(new MenuItem[]{reset}));
        table.setEditable(true);
        return table;
    }

    private static TableCell<Category, String> createNameCell(TableColumn<Category, String> column) {
        TableCell cell = (TableCell)TableColumn.DEFAULT_CELL_FACTORY.call(column);
        cell.setAlignment(Pos.CENTER_LEFT);
        return cell;
    }

    private static ObservableValue<String> getCategoryName(TableColumn.CellDataFeatures<Category, String> cell) {
        InternationalString name = ((Category)cell.getValue()).getName();
        return name != null ? new ImmutableObjectProperty<String>(name.toString()) : null;
    }
}

