/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.coldctr;

import org.apache.rocketmq.broker.coldctr.ColdCtrStrategy;
import org.apache.rocketmq.broker.coldctr.ColdDataCgCtrService;

public class SimpleColdCtrStrategy
implements ColdCtrStrategy {
    private final ColdDataCgCtrService coldDataCgCtrService;

    public SimpleColdCtrStrategy(ColdDataCgCtrService coldDataCgCtrService) {
        this.coldDataCgCtrService = coldDataCgCtrService;
    }

    @Override
    public Double decisionFactor() {
        return null;
    }

    @Override
    public void promote(String consumerGroup, Long currentThreshold) {
        this.coldDataCgCtrService.addOrUpdateGroupConfig(consumerGroup, (long)((double)currentThreshold.longValue() * 1.5));
    }

    @Override
    public void decelerate(String consumerGroup, Long currentThreshold) {
        if (!this.coldDataCgCtrService.isGlobalColdCtr()) {
            return;
        }
        long changedThresholdVal = (long)((double)currentThreshold.longValue() * 0.8);
        if (changedThresholdVal < this.coldDataCgCtrService.getBrokerConfig().getCgColdReadThreshold()) {
            changedThresholdVal = this.coldDataCgCtrService.getBrokerConfig().getCgColdReadThreshold();
        }
        this.coldDataCgCtrService.addOrUpdateGroupConfig(consumerGroup, changedThresholdVal);
    }

    @Override
    public void collect(Long globalAcc) {
    }
}

