/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.transaction.impl.operations;

import com.hazelcast.core.MemberLeftException;
import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.spi.impl.operationservice.ExceptionAction;
import com.hazelcast.transaction.impl.TransactionManagerServiceImpl;
import com.hazelcast.transaction.impl.operations.AbstractTxOperation;
import java.io.IOException;
import java.util.UUID;

public class CreateTxBackupLogOperation
extends AbstractTxOperation {
    private UUID callerUuid;
    private UUID txnId;

    public CreateTxBackupLogOperation() {
    }

    public CreateTxBackupLogOperation(UUID callerUuid, UUID txnId) {
        this.callerUuid = callerUuid;
        this.txnId = txnId;
    }

    @Override
    public void run() throws Exception {
        TransactionManagerServiceImpl txManagerService = (TransactionManagerServiceImpl)this.getService();
        txManagerService.createBackupLog(this.callerUuid, this.txnId);
    }

    @Override
    public Object getResponse() {
        return true;
    }

    @Override
    public ExceptionAction onInvocationException(Throwable throwable) {
        if (throwable instanceof MemberLeftException || throwable instanceof TargetNotMemberException) {
            return ExceptionAction.THROW_EXCEPTION;
        }
        return super.onInvocationException(throwable);
    }

    @Override
    public int getClassId() {
        return 0;
    }

    @Override
    public UUID getCallerUuid() {
        return this.callerUuid;
    }

    public UUID getTxnId() {
        return this.txnId;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        UUIDSerializationUtil.writeUUID(out, this.callerUuid);
        UUIDSerializationUtil.writeUUID(out, this.txnId);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.callerUuid = UUIDSerializationUtil.readUUID(in);
        this.txnId = UUIDSerializationUtil.readUUID(in);
    }
}

