/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql;

import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.spi.annotation.PrivateApi;
import com.hazelcast.sql.SqlColumnMetadata;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public final class SqlRowMetadata {
    public static final int COLUMN_NOT_FOUND = -1;
    private final List<SqlColumnMetadata> columns;
    private final Map<String, Integer> nameToIndex;

    @PrivateApi
    public SqlRowMetadata(@Nonnull List<SqlColumnMetadata> columns) {
        assert (columns != null && !columns.isEmpty());
        this.columns = Collections.unmodifiableList(columns);
        this.nameToIndex = new HashMap<String, Integer>(columns.size());
        for (int i = 0; i < columns.size(); ++i) {
            this.nameToIndex.put(columns.get(i).getName(), i);
        }
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    @Nonnull
    public SqlColumnMetadata getColumn(int index) {
        if (index < 0 || index >= this.columns.size()) {
            throw new IndexOutOfBoundsException("Column index is out of bounds: " + index);
        }
        return this.columns.get(index);
    }

    @Nonnull
    public List<SqlColumnMetadata> getColumns() {
        return this.columns;
    }

    public int findColumn(@Nonnull String columnName) {
        Preconditions.checkNotNull(columnName, "Column name cannot be null");
        return this.nameToIndex.getOrDefault(columnName, -1);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlRowMetadata that = (SqlRowMetadata)o;
        return this.columns.equals(that.columns);
    }

    public int hashCode() {
        return this.columns.hashCode();
    }

    public String toString() {
        return this.columns.stream().map(column -> column.getName() + " " + column.getType()).collect(Collectors.joining(", ", "[", "]"));
    }
}

