/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.config;

import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.config.JetConfigDataSerializerHook;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.annotation.PrivateApi;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nonnull;

public class DeltaJobConfig
implements IdentifiedDataSerializable {
    private Long snapshotIntervalMillis;
    private Boolean autoScaling;
    private Boolean suspendOnFailure;
    private Boolean splitBrainProtectionEnabled;
    private Boolean enableMetrics;
    private Boolean storeMetricsAfterJobCompletion;
    private Long maxProcessorAccumulatedRecords;
    private Long timeoutMillis;

    @Nonnull
    public DeltaJobConfig setSnapshotIntervalMillis(long snapshotInterval) {
        Preconditions.checkNotNegative(snapshotInterval, "snapshotInterval can't be negative");
        this.snapshotIntervalMillis = snapshotInterval;
        return this;
    }

    public DeltaJobConfig setAutoScaling(boolean enabled) {
        this.autoScaling = enabled;
        return this;
    }

    public DeltaJobConfig setSuspendOnFailure(boolean suspendOnFailure) {
        this.suspendOnFailure = suspendOnFailure;
        return this;
    }

    @Nonnull
    public DeltaJobConfig setSplitBrainProtection(boolean isEnabled) {
        this.splitBrainProtectionEnabled = isEnabled;
        return this;
    }

    @Nonnull
    public DeltaJobConfig setMetricsEnabled(boolean enabled) {
        this.enableMetrics = enabled;
        return this;
    }

    public DeltaJobConfig setStoreMetricsAfterJobCompletion(boolean storeMetricsAfterJobCompletion) {
        this.storeMetricsAfterJobCompletion = storeMetricsAfterJobCompletion;
        return this;
    }

    public DeltaJobConfig setMaxProcessorAccumulatedRecords(long maxProcessorAccumulatedRecords) {
        Preconditions.checkTrue(maxProcessorAccumulatedRecords > 0L || maxProcessorAccumulatedRecords == -1L, "maxProcessorAccumulatedRecords must be a positive number or -1");
        this.maxProcessorAccumulatedRecords = maxProcessorAccumulatedRecords;
        return this;
    }

    public DeltaJobConfig setTimeoutMillis(long timeoutMillis) {
        Preconditions.checkNotNegative(timeoutMillis, "timeoutMillis can't be negative");
        this.timeoutMillis = timeoutMillis;
        return this;
    }

    public void applyTo(JobConfig config) {
        if (this.snapshotIntervalMillis != null) {
            config.setSnapshotIntervalMillis(this.snapshotIntervalMillis);
        }
        if (this.autoScaling != null) {
            config.setAutoScaling(this.autoScaling);
        }
        if (this.suspendOnFailure != null) {
            config.setSuspendOnFailure(this.suspendOnFailure);
        }
        if (this.splitBrainProtectionEnabled != null) {
            config.setSplitBrainProtection(this.splitBrainProtectionEnabled);
        }
        if (this.enableMetrics != null) {
            config.setMetricsEnabled(this.enableMetrics);
        }
        if (this.storeMetricsAfterJobCompletion != null) {
            config.setStoreMetricsAfterJobCompletion(this.storeMetricsAfterJobCompletion);
        }
        if (this.maxProcessorAccumulatedRecords != null) {
            config.setMaxProcessorAccumulatedRecords(this.maxProcessorAccumulatedRecords);
        }
        if (this.timeoutMillis != null) {
            config.setTimeoutMillis(this.timeoutMillis);
        }
    }

    @Override
    @PrivateApi
    public int getFactoryId() {
        return JetConfigDataSerializerHook.FACTORY_ID;
    }

    @Override
    @PrivateApi
    public int getClassId() {
        return 3;
    }

    @Override
    @PrivateApi
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.snapshotIntervalMillis);
        SerializationUtil.writeNullableBoolean(out, this.autoScaling);
        SerializationUtil.writeNullableBoolean(out, this.suspendOnFailure);
        SerializationUtil.writeNullableBoolean(out, this.splitBrainProtectionEnabled);
        SerializationUtil.writeNullableBoolean(out, this.enableMetrics);
        SerializationUtil.writeNullableBoolean(out, this.storeMetricsAfterJobCompletion);
        out.writeObject(this.maxProcessorAccumulatedRecords);
        out.writeObject(this.timeoutMillis);
    }

    @Override
    @PrivateApi
    public void readData(ObjectDataInput in) throws IOException {
        this.snapshotIntervalMillis = (Long)in.readObject();
        this.autoScaling = SerializationUtil.readNullableBoolean(in);
        this.suspendOnFailure = SerializationUtil.readNullableBoolean(in);
        this.splitBrainProtectionEnabled = SerializationUtil.readNullableBoolean(in);
        this.enableMetrics = SerializationUtil.readNullableBoolean(in);
        this.storeMetricsAfterJobCompletion = SerializationUtil.readNullableBoolean(in);
        this.maxProcessorAccumulatedRecords = (Long)in.readObject();
        this.timeoutMillis = (Long)in.readObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeltaJobConfig config = (DeltaJobConfig)o;
        return Objects.equals(this.snapshotIntervalMillis, config.snapshotIntervalMillis) && this.autoScaling == config.autoScaling && this.suspendOnFailure == config.suspendOnFailure && this.splitBrainProtectionEnabled == config.splitBrainProtectionEnabled && this.enableMetrics == config.enableMetrics && this.storeMetricsAfterJobCompletion == config.storeMetricsAfterJobCompletion && Objects.equals(this.maxProcessorAccumulatedRecords, config.maxProcessorAccumulatedRecords) && Objects.equals(this.timeoutMillis, config.timeoutMillis);
    }

    public int hashCode() {
        return Objects.hash(this.snapshotIntervalMillis, this.autoScaling, this.suspendOnFailure, this.splitBrainProtectionEnabled, this.enableMetrics, this.storeMetricsAfterJobCompletion, this.maxProcessorAccumulatedRecords, this.timeoutMillis);
    }

    public String toString() {
        return "DeltaJobConfig {snapshotIntervalMillis=" + this.snapshotIntervalMillis + ", autoScaling=" + this.autoScaling + ", suspendOnFailure=" + this.suspendOnFailure + ", splitBrainProtectionEnabled=" + this.splitBrainProtectionEnabled + ", enableMetrics=" + this.enableMetrics + ", storeMetricsAfterJobCompletion=" + this.storeMetricsAfterJobCompletion + ", maxProcessorAccumulatedRecords=" + this.maxProcessorAccumulatedRecords + ", timeoutMillis=" + this.timeoutMillis + "}";
    }
}

