/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.tools;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.metadata.Metadata;
import org.apache.nutch.protocol.Content;
import org.apache.nutch.tools.CommonCrawlConfig;
import org.apache.nutch.tools.CommonCrawlFormat;
import org.apache.nutch.tools.CommonCrawlFormatJackson;
import org.apache.nutch.tools.CommonCrawlFormatJettinson;
import org.apache.nutch.tools.CommonCrawlFormatSimple;
import org.apache.nutch.tools.CommonCrawlFormatWARC;

public class CommonCrawlFormatFactory {
    public static CommonCrawlFormat getCommonCrawlFormat(String formatType, String url, Content content, Metadata metadata, Configuration nutchConf, CommonCrawlConfig config) throws IOException {
        if (formatType == null) {
            return null;
        }
        if (formatType.equalsIgnoreCase("jackson")) {
            return new CommonCrawlFormatJackson(url, content, metadata, nutchConf, config);
        }
        if (formatType.equalsIgnoreCase("jettinson")) {
            return new CommonCrawlFormatJettinson(url, content, metadata, nutchConf, config);
        }
        if (formatType.equalsIgnoreCase("simple")) {
            return new CommonCrawlFormatSimple(url, content, metadata, nutchConf, config);
        }
        return null;
    }

    public static CommonCrawlFormat getCommonCrawlFormat(String formatType, Configuration nutchConf, CommonCrawlConfig config) throws IOException {
        if (formatType.equalsIgnoreCase("WARC")) {
            return new CommonCrawlFormatWARC(nutchConf, config);
        }
        if (formatType.equalsIgnoreCase("JACKSON")) {
            return new CommonCrawlFormatJackson(nutchConf, config);
        }
        return null;
    }
}

