/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Locale;
import org.apache.solr.client.solrj.io.eval.ManyValueWorker;
import org.apache.solr.client.solrj.io.eval.RecursiveBooleanEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class EqualToEvaluator
extends RecursiveBooleanEvaluator
implements ManyValueWorker {
    protected static final long serialVersionUID = 1L;

    public EqualToEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (this.containedEvaluators.size() < 2) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting at least two values but found %d", expression, this.containedEvaluators.size()));
        }
    }

    @Override
    protected RecursiveBooleanEvaluator.Checker constructChecker(Object fromValue) throws IOException {
        if (null == fromValue) {
            return new RecursiveBooleanEvaluator.NullChecker(){

                @Override
                public boolean test(Object left, Object right) {
                    return null == left && null == right;
                }
            };
        }
        if (fromValue instanceof Boolean) {
            return new RecursiveBooleanEvaluator.BooleanChecker(){

                @Override
                public boolean test(Object left, Object right) {
                    return ((Boolean)left).booleanValue() == ((Boolean)right).booleanValue();
                }
            };
        }
        if (fromValue instanceof Number) {
            return new RecursiveBooleanEvaluator.NumberChecker(){

                @Override
                public boolean test(Object left, Object right) {
                    return 0 == new BigDecimal(left.toString()).compareTo(new BigDecimal(right.toString()));
                }
            };
        }
        if (fromValue instanceof String) {
            return new RecursiveBooleanEvaluator.StringChecker(){

                @Override
                public boolean test(Object left, Object right) {
                    return left.equals(right);
                }
            };
        }
        throw new IOException(String.format(Locale.ROOT, "Unable to check %s(...) for values of type '%s'", this.constructingFactory.getFunctionName(this.getClass()), fromValue.getClass().getSimpleName()));
    }
}

