/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.functions;

import org.apache.nifi.attribute.expression.language.EvaluationContext;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.StringEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.StringQueryResult;
import org.apache.nifi.uuid5.Uuid5Util;

public class Uuid5Evaluator
extends StringEvaluator {
    private final Evaluator<String> subject;
    private final Evaluator<String> namespace;

    public Uuid5Evaluator(Evaluator<String> subject, Evaluator<String> namespace) {
        this.subject = subject;
        this.namespace = namespace;
    }

    @Override
    public QueryResult<String> evaluate(EvaluationContext evaluationContext) {
        String subjectValue = this.subject.evaluate(evaluationContext).getValue();
        if (subjectValue == null) {
            return new StringQueryResult(null);
        }
        String nsValue = this.namespace.evaluate(evaluationContext).getValue();
        String uuid = Uuid5Util.fromString((String)subjectValue, (String)nsValue);
        return new StringQueryResult(uuid);
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subject;
    }
}

