/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.functions;

import org.apache.nifi.attribute.expression.language.EvaluationContext;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.NumberEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.NumberQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;

public class PlusEvaluator
extends NumberEvaluator {
    private final Evaluator<Number> subject;
    private final Evaluator<Number> plusValue;

    public PlusEvaluator(Evaluator<Number> subject, Evaluator<Number> plusValue) {
        this.subject = subject;
        this.plusValue = plusValue;
    }

    @Override
    public QueryResult<Number> evaluate(EvaluationContext evaluationContext) {
        Number subjectValue = this.subject.evaluate(evaluationContext).getValue();
        if (subjectValue == null) {
            return new NumberQueryResult(null);
        }
        Number plus = this.plusValue.evaluate(evaluationContext).getValue();
        if (plus == null) {
            return new NumberQueryResult(null);
        }
        Number result = subjectValue instanceof Double || plus instanceof Double ? (Number)(subjectValue.doubleValue() + plus.doubleValue()) : (Number)(subjectValue.longValue() + plus.longValue());
        return new NumberQueryResult(result);
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subject;
    }
}

