/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.proxied.entity;

import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.nifi.security.proxied.entity.ProxiedEntityEncoder;

public class StandardProxiedEntityEncoder
implements ProxiedEntityEncoder {
    private static final String DELIMITED_FORMAT = "<%s>";
    private static final String GT = ">";
    private static final String ESCAPED_GT = "\\\\>";
    private static final String LT = "<";
    private static final String ESCAPED_LT = "\\\\<";
    private static final Charset headerValueCharset = StandardCharsets.US_ASCII;
    private static final Base64.Encoder headerValueEncoder = Base64.getEncoder();
    private static final StandardProxiedEntityEncoder encoder = new StandardProxiedEntityEncoder();

    private StandardProxiedEntityEncoder() {
    }

    public static ProxiedEntityEncoder getInstance() {
        return encoder;
    }

    @Override
    public String getEncodedEntity(String identity) {
        String sanitizedIdentity = this.getSanitizedIdentity(identity);
        return DELIMITED_FORMAT.formatted(sanitizedIdentity);
    }

    private String getSanitizedIdentity(String identity) {
        String sanitized;
        if (identity == null || identity.isEmpty()) {
            sanitized = identity;
        } else {
            String escaped = identity.replaceAll(LT, ESCAPED_LT).replaceAll(GT, ESCAPED_GT);
            CharsetEncoder charsetEncoder = headerValueCharset.newEncoder();
            if (charsetEncoder.canEncode(escaped)) {
                sanitized = escaped;
            } else {
                byte[] escapedBinary = escaped.getBytes(StandardCharsets.UTF_8);
                String escapedEncoded = headerValueEncoder.encodeToString(escapedBinary);
                sanitized = DELIMITED_FORMAT.formatted(escapedEncoded);
            }
        }
        return sanitized;
    }
}

