/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.ui;

import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.security.web.server.csrf.CsrfToken;
import org.springframework.security.web.server.ui.HtmlTemplates;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatchers;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class LoginPageGeneratingWebFilter
implements WebFilter {
    private ServerWebExchangeMatcher matcher = ServerWebExchangeMatchers.pathMatchers(HttpMethod.GET, "/login");
    private Map<String, String> oauth2AuthenticationUrlToClientName = new HashMap<String, String>();
    private boolean formLoginEnabled;
    private boolean oneTimeTokenEnabled = false;
    private String generateOneTimeTokenUrl;
    private static final String LOGIN_PAGE_TEMPLATE = "<!DOCTYPE html>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1, shrink-to-fit=no\">\n    <meta name=\"description\" content=\"\">\n    <meta name=\"author\" content=\"\">\n    <title>Please sign in</title>\n    <link href=\"{{contextPath}}/default-ui.css\" rel=\"stylesheet\" />\n  </head>\n  <body>\n    <div class=\"content\">\n{{formLogin}}\n{{oneTimeTokenLogin}}\n{{oauth2Login}}\n    </div>\n  </body>\n</html>";
    private static final String LOGIN_FORM_TEMPLATE = "      <form class=\"login-form\" method=\"post\" action=\"{{loginUrl}}\">\n        <h2>Please sign in</h2>\n{{errorMessage}}{{logoutMessage}}\n        <p>\n          <label for=\"username\" class=\"screenreader\">Username</label>\n          <input type=\"text\" id=\"username\" name=\"username\" placeholder=\"Username\" required autofocus>\n        </p>\n        <p>\n          <label for=\"password\" class=\"screenreader\">Password</label>\n          <input type=\"password\" id=\"password\" name=\"password\" placeholder=\"Password\" required>\n        </p>\n{{csrf}}\n        <button type=\"submit\" class=\"primary\">Sign in</button>\n      </form>";
    private static final String CSRF_INPUT_TEMPLATE = "<input name=\"{{name}}\" type=\"hidden\" value=\"{{value}}\" />\n";
    private static final String OAUTH2_LOGIN_TEMPLATE = "<h2>Login with OAuth 2.0</h2>\n{{errorMessage}}\n<table class=\"table table-striped\">\n{{oauth2Rows}}\n</table>";
    private static final String OAUTH2_ROW_TEMPLATE = "<tr><td><a href=\"{{url}}\">{{clientName}}</a></td></tr>";
    private static final String ONE_TIME_TEMPLATE = "      <form id=\"ott-form\" class=\"login-form\" method=\"post\" action=\"{{generateOneTimeTokenUrl}}\">\n        <h2>Request a One-Time Token</h2>\n      {{errorMessage}}{{logoutMessage}}\n        <p>\n          <label for=\"ott-username\" class=\"screenreader\">Username</label>\n          <input type=\"text\" id=\"ott-username\" name=\"username\" placeholder=\"Username\" required>\n        </p>\n        {{csrf}}\n        <button class=\"primary\" type=\"submit\" form=\"ott-form\">Send Token</button>\n      </form>\n";

    public void setGenerateOneTimeTokenUrl(String generateOneTimeTokenUrl) {
        Assert.isTrue((boolean)StringUtils.hasText((String)generateOneTimeTokenUrl), (String)"generateOneTimeTokenUrl cannot be null or empty");
        this.generateOneTimeTokenUrl = generateOneTimeTokenUrl;
    }

    public void setFormLoginEnabled(boolean enabled) {
        this.formLoginEnabled = enabled;
    }

    public void setOneTimeTokenEnabled(boolean oneTimeTokenEnabled) {
        this.oneTimeTokenEnabled = oneTimeTokenEnabled;
    }

    public void setOauth2AuthenticationUrlToClientName(Map<String, String> oauth2AuthenticationUrlToClientName) {
        Assert.notNull(oauth2AuthenticationUrlToClientName, (String)"oauth2AuthenticationUrlToClientName cannot be null");
        this.oauth2AuthenticationUrlToClientName = oauth2AuthenticationUrlToClientName;
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        return this.matcher.matches(exchange).filter(ServerWebExchangeMatcher.MatchResult::isMatch).switchIfEmpty(chain.filter(exchange).then(Mono.empty())).flatMap(matchResult -> this.render(exchange));
    }

    private Mono<Void> render(ServerWebExchange exchange) {
        ServerHttpResponse result = exchange.getResponse();
        result.setStatusCode((HttpStatusCode)HttpStatus.OK);
        result.getHeaders().setContentType(MediaType.TEXT_HTML);
        return result.writeWith(this.createBuffer(exchange));
    }

    private Mono<DataBuffer> createBuffer(ServerWebExchange exchange) {
        Mono token = (Mono)exchange.getAttributeOrDefault(CsrfToken.class.getName(), (Object)Mono.empty());
        return token.map(LoginPageGeneratingWebFilter::csrfToken).defaultIfEmpty((Object)"").map(csrfTokenHtmlInput -> {
            byte[] bytes = this.createPage(exchange, (String)csrfTokenHtmlInput);
            DataBufferFactory bufferFactory = exchange.getResponse().bufferFactory();
            return bufferFactory.wrap(bytes);
        });
    }

    private byte[] createPage(ServerWebExchange exchange, String csrfTokenHtmlInput) {
        MultiValueMap queryParams = exchange.getRequest().getQueryParams();
        String contextPath = exchange.getRequest().getPath().contextPath().value();
        return HtmlTemplates.fromTemplate(LOGIN_PAGE_TEMPLATE).withRawHtml("contextPath", contextPath).withRawHtml("formLogin", this.formLogin((MultiValueMap<String, String>)queryParams, contextPath, csrfTokenHtmlInput)).withRawHtml("oneTimeTokenLogin", this.renderOneTimeTokenLogin((MultiValueMap<String, String>)queryParams, contextPath, csrfTokenHtmlInput)).withRawHtml("oauth2Login", LoginPageGeneratingWebFilter.oauth2Login((MultiValueMap<String, String>)queryParams, contextPath, this.oauth2AuthenticationUrlToClientName)).render().getBytes(Charset.defaultCharset());
    }

    private String formLogin(MultiValueMap<String, String> queryParams, String contextPath, String csrfTokenHtmlInput) {
        if (!this.formLoginEnabled) {
            return "";
        }
        boolean isError = queryParams.containsKey((Object)"error");
        boolean isLogoutSuccess = queryParams.containsKey((Object)"logout");
        return HtmlTemplates.fromTemplate(LOGIN_FORM_TEMPLATE).withValue("loginUrl", contextPath + "/login").withRawHtml("errorMessage", LoginPageGeneratingWebFilter.createError(isError)).withRawHtml("logoutMessage", LoginPageGeneratingWebFilter.createLogoutSuccess(isLogoutSuccess)).withRawHtml("csrf", csrfTokenHtmlInput).render();
    }

    private String renderOneTimeTokenLogin(MultiValueMap<String, String> queryParams, String contextPath, String csrfTokenHtmlInput) {
        if (!this.oneTimeTokenEnabled) {
            return "";
        }
        boolean isError = queryParams.containsKey((Object)"error");
        boolean isLogoutSuccess = queryParams.containsKey((Object)"logout");
        return HtmlTemplates.fromTemplate(ONE_TIME_TEMPLATE).withValue("generateOneTimeTokenUrl", contextPath + this.generateOneTimeTokenUrl).withRawHtml("errorMessage", LoginPageGeneratingWebFilter.createError(isError)).withRawHtml("logoutMessage", LoginPageGeneratingWebFilter.createLogoutSuccess(isLogoutSuccess)).withRawHtml("csrf", csrfTokenHtmlInput).render();
    }

    private static String oauth2Login(MultiValueMap<String, String> queryParams, String contextPath, Map<String, String> oauth2AuthenticationUrlToClientName) {
        if (oauth2AuthenticationUrlToClientName.isEmpty()) {
            return "";
        }
        boolean isError = queryParams.containsKey((Object)"error");
        String oauth2Rows = oauth2AuthenticationUrlToClientName.entrySet().stream().map(urlToName -> LoginPageGeneratingWebFilter.oauth2LoginLink(contextPath, (String)urlToName.getKey(), (String)urlToName.getValue())).collect(Collectors.joining("\n")).indent(2);
        return HtmlTemplates.fromTemplate(OAUTH2_LOGIN_TEMPLATE).withRawHtml("errorMessage", LoginPageGeneratingWebFilter.createError(isError)).withRawHtml("oauth2Rows", oauth2Rows).render();
    }

    private static String oauth2LoginLink(String contextPath, String url, String clientName) {
        return HtmlTemplates.fromTemplate(OAUTH2_ROW_TEMPLATE).withValue("url", contextPath + url).withValue("clientName", clientName).render();
    }

    private static String csrfToken(CsrfToken token) {
        return HtmlTemplates.fromTemplate(CSRF_INPUT_TEMPLATE).withValue("name", token.getParameterName()).withValue("value", token.getToken()).render();
    }

    private static String createError(boolean isError) {
        return isError ? "<div class=\"alert alert-danger\" role=\"alert\">Invalid credentials</div>" : "";
    }

    private static String createLogoutSuccess(boolean isLogoutSuccess) {
        return isLogoutSuccess ? "<div class=\"alert alert-success\" role=\"alert\">You have been signed out</div>" : "";
    }
}

