/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.internal;

import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseHttpFields
extends HttpFields.Mutable.Wrapper {
    private static final Logger LOG = LoggerFactory.getLogger(ResponseHttpFields.class);
    private final AtomicBoolean _committed = new AtomicBoolean();

    public ResponseHttpFields() {
        super(HttpFields.build());
    }

    public HttpFields.Mutable getMutableHttpFields() {
        return this.getWrapped();
    }

    public boolean commit() {
        boolean committed = this._committed.compareAndSet(false, true);
        if (committed && LOG.isDebugEnabled()) {
            LOG.debug("{} committed", (Object)this);
        }
        return committed;
    }

    public boolean isCommitted() {
        return this._committed.get();
    }

    public HttpField onAddField(HttpField field) {
        if (this.isCommitted()) {
            return null;
        }
        return super.onAddField(field);
    }

    public boolean onRemoveField(HttpField field) {
        return !this.isCommitted() && !Persistent.isPersistent(field);
    }

    public HttpField onReplaceField(HttpField oldField, HttpField newField) {
        if (this.isCommitted() || newField == null || !newField.isSameName(oldField)) {
            return oldField;
        }
        if (oldField instanceof Persistent) {
            Persistent persistent = (Persistent)oldField;
            newField = newField instanceof PreEncodedHttpField ? new PersistentPreEncodedHttpField(oldField.getHeader(), newField.getValue(), persistent.getOriginal()) : new PersistentHttpField((HttpField)newField, persistent.getOriginal());
        }
        return newField;
    }

    public void recycle() {
        this._committed.set(false);
        super.clear();
    }

    public HttpFields asImmutable() {
        return this._committed.get() ? this : this.getMutableHttpFields().asImmutable();
    }

    public HttpFields.Mutable clear() {
        if (!this._committed.get()) {
            ListIterator iterator = this.getMutableHttpFields().listIterator(this.size());
            while (iterator.hasPrevious()) {
                HttpField field = (HttpField)iterator.previous();
                if (field instanceof Persistent) {
                    Persistent persistent = (Persistent)field;
                    iterator.set(persistent.getOriginal());
                    continue;
                }
                iterator.remove();
            }
        }
        return this;
    }

    public static interface Persistent {
        public static boolean isPersistent(HttpField field) {
            return field instanceof Persistent;
        }

        public HttpField getOriginal();
    }

    public static class PersistentPreEncodedHttpField
    extends PreEncodedHttpField
    implements Persistent {
        private final HttpField _original;

        public PersistentPreEncodedHttpField(HttpHeader header, String value) {
            this(header, value, null);
        }

        PersistentPreEncodedHttpField(HttpHeader header, String value, HttpField original) {
            super(header, value);
            this._original = original == null ? this : original;
        }

        @Override
        public HttpField getOriginal() {
            return this._original;
        }
    }

    public static class PersistentHttpField
    extends HttpField
    implements Persistent {
        private final HttpField _field;
        private final HttpField _original;

        public PersistentHttpField(HttpField field) {
            this(field, null);
        }

        PersistentHttpField(HttpField field, HttpField original) {
            super(field.getHeader(), field.getName(), field.getValue());
            this._field = field;
            this._original = original == null ? this : original;
        }

        public int getIntValue() {
            return this._field.getIntValue();
        }

        public long getLongValue() {
            return this._field.getIntValue();
        }

        @Override
        public HttpField getOriginal() {
            return this._original;
        }
    }
}

