/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.commons.utils;

import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;

public final class RetryUtil {
    private RetryUtil() {
        throw new UnsupportedOperationException();
    }

    public static <T> Optional<T> retry(Supplier<T> input, Predicate<T> predicate, int maxRetries, int pauseDurationMillis) {
        int retries = 0;
        T t;
        while (!predicate.test(t = input.get())) {
            if (retries == maxRetries) {
                return Optional.ofNullable(t);
            }
            ++retries;
            try {
                Thread.sleep(pauseDurationMillis);
            }
            catch (InterruptedException interruptedException) {
            }
        }
        return Optional.empty();
    }
}

