/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.registry.bucket;

import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.ParseException;
import org.apache.nifi.registry.client.BucketClient;
import org.apache.nifi.registry.client.FlowClient;
import org.apache.nifi.registry.client.NiFiRegistryClient;
import org.apache.nifi.registry.client.NiFiRegistryException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.registry.AbstractNiFiRegistryCommand;
import org.apache.nifi.toolkit.cli.impl.result.OkResult;

public class DeleteBucket
extends AbstractNiFiRegistryCommand<OkResult> {
    public DeleteBucket() {
        super("delete-bucket", OkResult.class);
    }

    @Override
    public String getDescription() {
        return "Deletes the bucket with the given id. If the bucket contains any items then the force option must be used.";
    }

    @Override
    protected void doInitialize(Context context) {
        this.addOption(CommandOption.BUCKET_ID.createOption());
        this.addOption(CommandOption.FORCE.createOption());
    }

    @Override
    public OkResult doExecute(NiFiRegistryClient client, Properties properties) throws IOException, NiFiRegistryException, ParseException {
        String bucketId = this.getRequiredArg(properties, CommandOption.BUCKET_ID);
        boolean forceDelete = properties.containsKey(CommandOption.FORCE.getLongName());
        FlowClient flowClient = client.getFlowClient();
        List flowsInBucket = flowClient.getByBucket(bucketId);
        if (flowsInBucket != null && !flowsInBucket.isEmpty() && !forceDelete) {
            throw new NiFiRegistryException("Bucket is not empty, use --" + CommandOption.FORCE.getLongName() + " to delete");
        }
        BucketClient bucketClient = client.getBucketClient();
        bucketClient.delete(bucketId);
        return new OkResult(this.getContext().isInteractive());
    }
}

