/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.registry;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.nifi.RegistryBranchesResult;
import org.apache.nifi.toolkit.client.NiFiClient;
import org.apache.nifi.toolkit.client.NiFiClientException;
import org.apache.nifi.web.api.entity.FlowRegistryBranchesEntity;

public class ListBranches
extends AbstractNiFiCommand<RegistryBranchesResult> {
    public ListBranches() {
        super("list-branches", RegistryBranchesResult.class);
    }

    @Override
    protected void doInitialize(Context context) {
        super.doInitialize(context);
        this.addOption(CommandOption.REGISTRY_CLIENT_ID.createOption());
    }

    @Override
    public String getDescription() {
        return "Returns the list of branches seen by the specified registry client.";
    }

    @Override
    public RegistryBranchesResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException {
        String regClientId = this.getRequiredArg(properties, CommandOption.REGISTRY_CLIENT_ID);
        FlowRegistryBranchesEntity branches = client.getFlowClient().getFlowRegistryBranches(regClientId);
        return new RegistryBranchesResult(this.getResultType(properties), branches);
    }
}

