/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedThreadPoolMBean;
import org.apache.camel.spi.ManagementStrategy;

@ManagedResource(description="Managed ThreadPool")
public class ManagedThreadPool
implements ManagedThreadPoolMBean {
    private final CamelContext camelContext;
    private final ThreadPoolExecutor threadPool;
    private final String id;
    private final String sourceId;
    private final String routeId;
    private final String threadPoolProfileId;

    public ManagedThreadPool(CamelContext camelContext, ThreadPoolExecutor threadPool, String id, String sourceId, String routeId, String threadPoolProfileId) {
        this.camelContext = camelContext;
        this.threadPool = threadPool;
        this.sourceId = sourceId;
        this.id = id;
        this.routeId = routeId;
        this.threadPoolProfileId = threadPoolProfileId;
    }

    public void init(ManagementStrategy strategy) {
    }

    public CamelContext getContext() {
        return this.camelContext;
    }

    public ThreadPoolExecutor getThreadPool() {
        return this.threadPool;
    }

    public String getCamelId() {
        return this.camelContext.getName();
    }

    public String getCamelManagementName() {
        return this.camelContext.getManagementName();
    }

    public String getId() {
        return this.id;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public String getThreadPoolProfileId() {
        return this.threadPoolProfileId;
    }

    public int getCorePoolSize() {
        return this.threadPool.getCorePoolSize();
    }

    public void setCorePoolSize(int corePoolSize) {
        this.threadPool.setCorePoolSize(corePoolSize);
    }

    public int getPoolSize() {
        return this.threadPool.getPoolSize();
    }

    public int getMaximumPoolSize() {
        return this.threadPool.getMaximumPoolSize();
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        this.threadPool.setMaximumPoolSize(maximumPoolSize);
    }

    public int getLargestPoolSize() {
        return this.threadPool.getLargestPoolSize();
    }

    public int getActiveCount() {
        return this.threadPool.getActiveCount();
    }

    public long getTaskCount() {
        return this.threadPool.getTaskCount();
    }

    public long getCompletedTaskCount() {
        return this.threadPool.getCompletedTaskCount();
    }

    public long getTaskQueueSize() {
        if (this.threadPool.getQueue() != null) {
            return this.threadPool.getQueue().size();
        }
        return 0L;
    }

    public boolean isTaskQueueEmpty() {
        if (this.threadPool.getQueue() != null) {
            return this.threadPool.getQueue().isEmpty();
        }
        return true;
    }

    public long getKeepAliveTime() {
        return this.threadPool.getKeepAliveTime(TimeUnit.SECONDS);
    }

    public void setKeepAliveTime(long keepAliveTimeInSeconds) {
        this.threadPool.setKeepAliveTime(keepAliveTimeInSeconds, TimeUnit.SECONDS);
    }

    public boolean isAllowCoreThreadTimeout() {
        return this.threadPool.allowsCoreThreadTimeOut();
    }

    public void setAllowCoreThreadTimeout(boolean allowCoreThreadTimeout) {
        this.threadPool.allowCoreThreadTimeOut(allowCoreThreadTimeout);
    }

    public boolean isShutdown() {
        return this.threadPool.isShutdown();
    }

    public void purge() {
        this.threadPool.purge();
    }

    public int getTaskQueueRemainingCapacity() {
        if (this.threadPool.getQueue() != null) {
            return this.threadPool.getQueue().remainingCapacity();
        }
        return 0;
    }
}

