/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dataformat;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.dataformat.DataFormatEndpoint;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.util.StringHelper;

@org.apache.camel.spi.annotations.Component(value="dataformat")
public class DataFormatComponent
extends DefaultComponent {
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String name = StringHelper.before((String)remaining, (String)":");
        DataFormat df = this.getCamelContext().resolveDataFormat(name);
        if (df == null) {
            df = this.getCamelContext().createDataFormat(name);
        }
        if (df == null) {
            throw new IllegalArgumentException("Cannot find data format with name: " + name);
        }
        String operation = StringHelper.after((String)remaining, (String)":");
        if (!"marshal".equals(operation) && !"unmarshal".equals(operation)) {
            throw new IllegalArgumentException("Operation must be either marshal or unmarshal, was: " + operation);
        }
        PropertyBindingSupport.bindProperties((CamelContext)this.getCamelContext(), (Object)df, parameters);
        DataFormatEndpoint endpoint = new DataFormatEndpoint(uri, (Component)this, df);
        endpoint.setOperation(operation);
        this.setProperties((Endpoint)endpoint, parameters);
        return endpoint;
    }
}

