/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.blueprint;

import org.apache.camel.CamelContext;
import org.apache.camel.core.osgi.OsgiLanguageResolver;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.LanguageResolver;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlueprintLanguageResolver
extends OsgiLanguageResolver {
    private static final Logger LOG = LoggerFactory.getLogger(BlueprintLanguageResolver.class);

    public BlueprintLanguageResolver(BundleContext bundleContext) {
        super(bundleContext);
    }

    public Language resolveLanguage(String name, CamelContext context) {
        try {
            Object bean = context.getRegistry().lookupByName(".camelBlueprint.languageResolver." + name);
            if (bean instanceof LanguageResolver) {
                LOG.debug("Found language resolver: {} in registry: {}", (Object)name, bean);
                return ((LanguageResolver)bean).resolveLanguage(name, context);
            }
        }
        catch (Exception e) {
            LOG.trace("Ignored error looking up bean: " + name + " due: " + e.getMessage(), (Throwable)e);
        }
        return super.resolveLanguage(name, context);
    }
}

