/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.client;

import org.apache.http.HttpException;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.http.header.Thrown;
import org.apache.juneau.rest.client.RestResponse;

public class RestCallException
extends HttpException {
    private static final long serialVersionUID = 1L;
    private final int statusCode;
    private final Thrown thrown;

    private static String clean(String message) {
        message = Utils.emptyIfNull(message);
        boolean needsCleaning = false;
        for (int i = 0; i < message.length() && !needsCleaning; ++i) {
            if (message.charAt(i) >= ' ') continue;
            needsCleaning = true;
        }
        if (!needsCleaning) {
            return message;
        }
        StringBuilder sb = new StringBuilder(message.length());
        for (int i = 0; i < message.length(); ++i) {
            char c = message.charAt(i);
            sb.append(c < ' ' ? (char)' ' : (char)c);
        }
        return sb.toString();
    }

    private static String format(String msg, Object ... args) {
        if (args.length == 0) {
            return RestCallException.clean(msg);
        }
        return RestCallException.clean(Utils.f(msg, args));
    }

    public RestCallException(int statusCode, Thrown thrown, Throwable cause, String message, Object ... args) {
        super(RestCallException.format(message, args), cause);
        this.statusCode = statusCode;
        this.thrown = thrown;
    }

    public RestCallException(RestResponse response, Throwable cause, String message, Object ... args) {
        this(response == null ? 0 : response.getStatusCode(), response == null ? Thrown.EMPTY : (Thrown)response.getHeader("Thrown").as(Thrown.class).orElse(null), cause, message, args);
    }

    public <T extends Throwable> T getCause(Class<T> c) {
        return ThrowableUtils.getThrowableCause(c, (Throwable)((Object)this));
    }

    public int getResponseCode() {
        return this.statusCode;
    }

    public Thrown getThrown() {
        return this.thrown;
    }
}

