/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.assertions;

import java.io.PrintStream;
import java.util.function.Function;
import org.apache.juneau.assertions.Assertion;
import org.apache.juneau.assertions.FluentObjectAssertion;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.cp.Messages;

public class FluentComparableAssertion<T extends Comparable, R>
extends FluentObjectAssertion<T, R> {
    private static final Messages MESSAGES = Messages.of(FluentComparableAssertion.class, "Messages");
    private static final String MSG_valueWasNotGreaterThanExpected = MESSAGES.getString("valueWasNotGreaterThanExpected");
    private static final String MSG_valueWasNotGreaterOrEqualsToExpected = MESSAGES.getString("valueWasNotGreaterOrEqualsToExpected");
    private static final String MSG_valueWasNotLessThanExpected = MESSAGES.getString("valueWasNotLessThanExpected");
    private static final String MSG_valueWasNotLessOrEqualsToExpected = MESSAGES.getString("valueWasNotLessOrEqualsToExpected");

    public FluentComparableAssertion(Assertion creator, T value, R returns) {
        super(creator, value, returns);
    }

    public FluentComparableAssertion(T value, R returns) {
        this(null, value, returns);
    }

    @Override
    public FluentComparableAssertion<T, R> asTransformed(Function<T, T> function) {
        return new FluentComparableAssertion(this, (Comparable)function.apply(this.orElse(null)), this.returns());
    }

    public R isBetween(Comparable lower, Comparable upper) throws AssertionError {
        this.isExists();
        AssertionUtils.assertArgNotNull("lower", lower);
        AssertionUtils.assertArgNotNull("upper", upper);
        this.isLte(upper);
        this.isGte(lower);
        return this.returns();
    }

    public R isGt(Comparable value) throws AssertionError {
        AssertionUtils.assertArgNotNull("value", value);
        if (((Comparable)this.value()).compareTo(value) <= 0) {
            throw this.error(MSG_valueWasNotGreaterThanExpected, Utils.r(value), Utils.r(this.value()));
        }
        return this.returns();
    }

    public R isGte(Comparable value) throws AssertionError {
        AssertionUtils.assertArgNotNull("value", value);
        if (((Comparable)this.value()).compareTo(value) < 0) {
            throw this.error(MSG_valueWasNotGreaterOrEqualsToExpected, Utils.r(value), Utils.r(this.value()));
        }
        return this.returns();
    }

    public R isLt(Comparable value) throws AssertionError {
        AssertionUtils.assertArgNotNull("value", value);
        if (((Comparable)this.value()).compareTo(value) >= 0) {
            throw this.error(MSG_valueWasNotLessThanExpected, Utils.r(value), Utils.r(this.value()));
        }
        return this.returns();
    }

    public R isLte(Comparable value) throws AssertionError {
        AssertionUtils.assertArgNotNull("value", value);
        if (((Comparable)this.value()).compareTo(value) > 0) {
            throw this.error(MSG_valueWasNotLessOrEqualsToExpected, Utils.r(value), Utils.r(this.value()));
        }
        return this.returns();
    }

    @Override
    public FluentComparableAssertion<T, R> setMsg(String msg, Object ... args) {
        super.setMsg(msg, args);
        return this;
    }

    @Override
    public FluentComparableAssertion<T, R> setOut(PrintStream value) {
        super.setOut(value);
        return this;
    }

    @Override
    public FluentComparableAssertion<T, R> setSilent() {
        super.setSilent();
        return this;
    }

    @Override
    public FluentComparableAssertion<T, R> setStdOut() {
        super.setStdOut();
        return this;
    }

    @Override
    public FluentComparableAssertion<T, R> setThrowable(Class<? extends RuntimeException> value) {
        super.setThrowable((Class)value);
        return this;
    }
}

