/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml.bind.cat;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.XmlValue;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.sis.util.iso.Types;
import org.apache.sis.xml.bind.Context;
import org.apache.sis.xml.bind.cat.CodeListAdapter;
import org.opengis.util.CodeList;

@XmlType(name="CodeList", propOrder={"codeList", "codeListValue", "codeSpace"})
public final class CodeListUID {
    public static final String METADATA_ROOT = "http://standards.iso.org/iso/19115/";
    public static final String METADATA_ROOT_LEGACY = "http://www.isotc211.org/2005/";
    public static final String CODELISTS_PATH = "resources/Codelist/cat/codelists.xml";
    public static final String CODELISTS_PATH_LEGACY = "resources/Codelist/gmxCodelists.xml";
    public static final String UOM_PATH = "resources/uom/gmxUom.xml";
    @XmlAttribute(required=true)
    public String codeList;
    @XmlAttribute(required=true)
    public String codeListValue;
    @XmlAttribute
    public String codeSpace;
    @XmlValue
    public String value;

    private static String schema(Context context2, String identifier) {
        String path;
        String root2;
        String prefix;
        if (Context.isFlagSet(context2, 32)) {
            prefix = "gmd";
            root2 = METADATA_ROOT_LEGACY;
            path = CODELISTS_PATH_LEGACY;
        } else {
            prefix = "cat";
            root2 = METADATA_ROOT;
            path = CODELISTS_PATH;
        }
        return Context.schema(context2, prefix, root2).append(path).append('#').append(identifier).toString();
    }

    public CodeListUID() {
    }

    public CodeListUID(Context context2, String codeList, String codeListValue, String codeSpace, String value) {
        this.codeList = CodeListUID.schema(context2, codeList);
        this.codeListValue = codeListValue;
        this.codeSpace = codeSpace;
        this.value = value;
    }

    public CodeListUID(Context context2, CodeList<?> code) {
        String classID = Types.getListName(code);
        String fieldID = Types.getCodeName(code);
        this.codeList = CodeListUID.schema(context2, classID);
        Locale locale = context2.getLocale();
        if (locale != null) {
            String key = classID + "." + fieldID;
            try {
                this.value = ResourceBundle.getBundle("org.apache.sis.metadata.iso.CodeLists", locale, CodeList.class.getClassLoader()).getString(key);
            }
            catch (MissingResourceException e2) {
                Context.warningOccured(context2, CodeListAdapter.class, "marshal", e2, false);
            }
        }
        if (this.value != null) {
            this.codeSpace = Context.converter(context2).toLanguageCode(context2, locale);
        } else {
            this.value = Types.getCodeLabel(code);
        }
        this.codeListValue = fieldID;
    }

    public String toString() {
        String id = this.codeListValue;
        if (id == null) {
            id = this.value;
        }
        return id;
    }
}

