/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.reader;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQPropertyConversionException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;

public class MessageUtil {
    public static final String CORRELATIONID_HEADER_NAME_STRING = "JMSCorrelationID";
    public static final SimpleString CORRELATIONID_HEADER_NAME = SimpleString.of((String)"JMSCorrelationID");
    public static final SimpleString REPLYTO_HEADER_NAME = SimpleString.of((String)"JMSReplyTo");
    public static final String TYPE_HEADER_NAME_STRING = "JMSType";
    public static final SimpleString TYPE_HEADER_NAME = SimpleString.of((String)"JMSType");
    public static final SimpleString JMS = SimpleString.of((String)"JMS");
    public static final SimpleString JMSX = SimpleString.of((String)"JMSX");
    public static final SimpleString JMS_ = SimpleString.of((String)"JMS_");
    public static final String JMSXDELIVERYCOUNT = "JMSXDeliveryCount";
    public static final String JMSXGROUPID = "JMSXGroupID";
    public static final String JMSXGROUPSEQ = "JMSXGroupSeq";
    public static final String JMSXUSERID = "JMSXUserID";
    public static final String CONNECTION_ID_PROPERTY_NAME_STRING = "__AMQ_CID";
    public static final SimpleString CONNECTION_ID_PROPERTY_NAME = SimpleString.of((String)"__AMQ_CID");

    public static byte[] getJMSCorrelationIDAsBytes(Message message) {
        Object obj = message.getObjectProperty(CORRELATIONID_HEADER_NAME);
        if (obj instanceof byte[]) {
            byte[] bytes = (byte[])obj;
            return bytes;
        }
        return null;
    }

    public static void setJMSType(Message message, String type) {
        message.putStringProperty(TYPE_HEADER_NAME, SimpleString.of((String)type));
    }

    public static String getJMSType(Message message) {
        SimpleString ss = message.getSimpleStringProperty(TYPE_HEADER_NAME);
        if (ss != null) {
            return ss.toString();
        }
        return null;
    }

    public static final void setJMSCorrelationIDAsBytes(Message message, byte[] correlationID) throws ActiveMQException {
        if (correlationID == null || correlationID.length == 0) {
            throw new ActiveMQException("Please specify a non-zero length byte[]");
        }
        message.putBytesProperty(CORRELATIONID_HEADER_NAME, correlationID);
    }

    public static void setJMSCorrelationID(Message message, String correlationID) {
        if (correlationID == null) {
            message.removeProperty(CORRELATIONID_HEADER_NAME);
        } else {
            message.putStringProperty(CORRELATIONID_HEADER_NAME, SimpleString.of((String)correlationID));
        }
    }

    public static String getJMSCorrelationID(Message message) {
        try {
            return message.getStringProperty(CORRELATIONID_HEADER_NAME);
        }
        catch (ActiveMQPropertyConversionException e) {
            return null;
        }
    }

    public static SimpleString getJMSReplyTo(Message message) {
        return message.getSimpleStringProperty(REPLYTO_HEADER_NAME);
    }

    public static void setJMSReplyTo(Message message, String dest) {
        if (dest == null) {
            message.removeProperty(REPLYTO_HEADER_NAME);
        } else {
            message.putStringProperty(REPLYTO_HEADER_NAME, dest);
        }
    }

    public static void setJMSReplyTo(Message message, SimpleString dest) {
        if (dest == null) {
            message.removeProperty(REPLYTO_HEADER_NAME);
        } else {
            message.putStringProperty(REPLYTO_HEADER_NAME, dest);
        }
    }

    public static void clearProperties(Message message) {
        ArrayList<SimpleString> toRemove = new ArrayList<SimpleString>();
        for (SimpleString propName : message.getPropertyNames()) {
            if (propName.startsWith(JMS) && !propName.startsWith(JMSX) && !propName.startsWith(JMS_) || propName.equals((Object)Message.HDR_ROUTING_TYPE)) continue;
            toRemove.add(propName);
        }
        for (SimpleString propName : toRemove) {
            message.removeProperty(propName);
        }
    }

    public static Set<String> getPropertyNames(Message message) {
        HashSet<String> set = new HashSet<String>();
        for (SimpleString propName : message.getPropertyNames()) {
            if (propName.equals((Object)Message.HDR_GROUP_ID)) {
                set.add(JMSXGROUPID);
                continue;
            }
            if (propName.equals((Object)Message.HDR_GROUP_SEQUENCE)) {
                set.add(JMSXGROUPSEQ);
                continue;
            }
            if (propName.equals((Object)Message.HDR_VALIDATED_USER)) {
                set.add(JMSXUSERID);
                continue;
            }
            if (propName.startsWith(JMS) && !propName.startsWith(JMSX) && !propName.startsWith(JMS_) || propName.startsWith(CONNECTION_ID_PROPERTY_NAME) || propName.equals((Object)Message.HDR_ROUTING_TYPE) || propName.startsWith(Message.HDR_ROUTE_TO_IDS)) continue;
            set.add(propName.toString());
        }
        set.add(JMSXDELIVERYCOUNT);
        return set;
    }

    public static boolean propertyExists(Message message, String name) {
        return message.containsProperty(SimpleString.of((String)name)) || name.equals(JMSXDELIVERYCOUNT) || JMSXGROUPID.equals(name) && message.containsProperty(Message.HDR_GROUP_ID) || JMSXGROUPSEQ.equals(name) && message.containsProperty(Message.HDR_GROUP_SEQUENCE) || JMSXUSERID.equals(name) && message.containsProperty(Message.HDR_VALIDATED_USER);
    }

    public static String getStringProperty(Message message, String name) {
        if (JMSXGROUPID.equals(name)) {
            return Objects.toString(message.getGroupID(), null);
        }
        if (JMSXGROUPSEQ.equals(name)) {
            return Integer.toString(message.getGroupSequence());
        }
        if (JMSXUSERID.equals(name)) {
            return message.getValidatedUserID();
        }
        return message.getStringProperty(name);
    }

    public static Object getObjectProperty(Message message, String name) {
        Object val = JMSXGROUPID.equals(name) ? message.getGroupID() : (JMSXGROUPSEQ.equals(name) ? Integer.valueOf(message.getGroupSequence()) : (JMSXUSERID.equals(name) ? message.getValidatedUserID() : message.getObjectProperty(name)));
        if (val instanceof SimpleString) {
            return val.toString();
        }
        return val;
    }

    public static long getLongProperty(Message message, String name) {
        if (JMSXGROUPSEQ.equals(name)) {
            return message.getGroupSequence();
        }
        return message.getLongProperty(name);
    }

    public static int getIntProperty(Message message, String name) {
        if (JMSXGROUPSEQ.equals(name)) {
            return message.getGroupSequence();
        }
        return message.getIntProperty(name);
    }

    public static void setIntProperty(Message message, String name, int value) {
        if (JMSXGROUPSEQ.equals(name)) {
            message.setGroupSequence(value);
        } else {
            message.putIntProperty(name, value);
        }
    }

    public static void setLongProperty(Message message, String name, long value) {
        if (JMSXGROUPSEQ.equals(name)) {
            message.setGroupSequence((int)value);
        } else {
            message.putLongProperty(name, value);
        }
    }

    public static void setStringProperty(Message message, String name, String value) {
        if (JMSXGROUPID.equals(name)) {
            message.setGroupID(value);
        } else if (JMSXGROUPSEQ.equals(name)) {
            message.setGroupSequence(MessageUtil.getInteger(value));
        } else if (JMSXUSERID.equals(name)) {
            message.setValidatedUserID(value);
        } else {
            message.putStringProperty(name, value);
        }
    }

    public static void setObjectProperty(Message message, String name, Object value) {
        if (JMSXGROUPID.equals(name)) {
            message.setGroupID(value == null ? null : value.toString());
        } else if (JMSXGROUPSEQ.equals(name)) {
            message.setGroupSequence(MessageUtil.getInteger(value));
        } else if (JMSXUSERID.equals(name)) {
            message.setValidatedUserID(value == null ? null : value.toString());
        } else {
            message.putObjectProperty(name, value);
        }
    }

    private static int getInteger(Object value) {
        int integer;
        Objects.requireNonNull(value);
        if (value instanceof Integer) {
            Integer integerValue = (Integer)value;
            integer = integerValue;
        } else if (value instanceof Number) {
            Number number = (Number)value;
            integer = number.intValue();
        } else {
            integer = Integer.parseInt(value.toString());
        }
        return integer;
    }
}

