/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vault.metadata;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import jakarta.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.blob.api.BucketName;
import org.apache.james.core.Username;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class UserPerBucketDAO {
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final PreparedStatement addStatement;
    private final PreparedStatement removeStatement;
    private final PreparedStatement listStatement;
    private final PreparedStatement listBucketsStatement;

    @Inject
    UserPerBucketDAO(CqlSession session) {
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.addStatement = this.prepareAddUser(session);
        this.removeStatement = this.prepareRemoveBucket(session);
        this.listStatement = this.prepareListUser(session);
        this.listBucketsStatement = this.prepareListBuckets(session);
    }

    private PreparedStatement prepareAddUser(CqlSession session) {
        return session.prepare(QueryBuilder.insertInto((String)"userPerBucket").value("bucketName", (Term)QueryBuilder.bindMarker((String)"bucketName")).value("user", (Term)QueryBuilder.bindMarker((String)"user")).build());
    }

    private PreparedStatement prepareRemoveBucket(CqlSession session) {
        return session.prepare(((Delete)QueryBuilder.deleteFrom((String)"userPerBucket").whereColumn("bucketName").isEqualTo((Term)QueryBuilder.bindMarker((String)"bucketName"))).build());
    }

    private PreparedStatement prepareListUser(CqlSession session) {
        return session.prepare(((Select)QueryBuilder.selectFrom((String)"userPerBucket").column("user").whereColumn("bucketName").isEqualTo((Term)QueryBuilder.bindMarker((String)"bucketName"))).build());
    }

    private PreparedStatement prepareListBuckets(CqlSession session) {
        return session.prepare(QueryBuilder.selectFrom((String)"userPerBucket").column("bucketName").perPartitionLimit(1).build());
    }

    Flux<Username> retrieveUsers(BucketName bucketName) {
        return this.cassandraAsyncExecutor.executeRows((Statement)this.listStatement.bind(new Object[0]).setString("bucketName", bucketName.asString())).map(row -> row.getString("user")).map(Username::of);
    }

    Flux<BucketName> retrieveBuckets() {
        return this.cassandraAsyncExecutor.executeRows((Statement)this.listBucketsStatement.bind(new Object[0])).map(row -> row.getString("bucketName")).map(BucketName::of);
    }

    Mono<Void> addUser(BucketName bucketName, Username username) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)((BoundStatement)this.addStatement.bind(new Object[0]).setString("bucketName", bucketName.asString())).setString("user", username.asString()));
    }

    Mono<Void> deleteBucket(BucketName bucketName) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.removeStatement.bind(new Object[0]).setString("bucketName", bucketName.asString()));
    }
}

