/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.Script;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.AggregationVariant;
import org.opensearch.client.opensearch._types.aggregations.BucketAggregationBase;
import org.opensearch.client.opensearch._types.aggregations.ExtendedBounds;
import org.opensearch.client.opensearch._types.aggregations.HistogramOrder;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class HistogramAggregation
extends BucketAggregationBase
implements AggregationVariant {
    @Nullable
    private final ExtendedBounds<Double> extendedBounds;
    @Nullable
    private final ExtendedBounds<Double> hardBounds;
    @Nullable
    private final String field;
    @Nullable
    private final Double interval;
    @Nullable
    private final Integer minDocCount;
    @Nullable
    private final Double missing;
    @Nullable
    private final Double offset;
    @Nullable
    private final HistogramOrder order;
    @Nullable
    private final Script script;
    @Nullable
    private final String format;
    @Nullable
    private final Boolean keyed;
    public static final JsonpDeserializer<HistogramAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, HistogramAggregation::setupHistogramAggregationDeserializer);

    private HistogramAggregation(Builder builder) {
        super(builder);
        this.extendedBounds = builder.extendedBounds;
        this.hardBounds = builder.hardBounds;
        this.field = builder.field;
        this.interval = builder.interval;
        this.minDocCount = builder.minDocCount;
        this.missing = builder.missing;
        this.offset = builder.offset;
        this.order = builder.order;
        this.script = builder.script;
        this.format = builder.format;
        this.keyed = builder.keyed;
    }

    public static HistogramAggregation of(Function<Builder, ObjectBuilder<HistogramAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.Histogram;
    }

    @Nullable
    public final ExtendedBounds<Double> extendedBounds() {
        return this.extendedBounds;
    }

    @Nullable
    public final ExtendedBounds<Double> hardBounds() {
        return this.hardBounds;
    }

    @Nullable
    public final String field() {
        return this.field;
    }

    @Nullable
    public final Double interval() {
        return this.interval;
    }

    @Nullable
    public final Integer minDocCount() {
        return this.minDocCount;
    }

    @Nullable
    public final Double missing() {
        return this.missing;
    }

    @Nullable
    public final Double offset() {
        return this.offset;
    }

    @Nullable
    public final HistogramOrder order() {
        return this.order;
    }

    @Nullable
    public final Script script() {
        return this.script;
    }

    @Nullable
    public final String format() {
        return this.format;
    }

    @Nullable
    public final Boolean keyed() {
        return this.keyed;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.extendedBounds != null) {
            generator.writeKey("extended_bounds");
            this.extendedBounds.serialize(generator, mapper);
        }
        if (this.hardBounds != null) {
            generator.writeKey("hard_bounds");
            this.hardBounds.serialize(generator, mapper);
        }
        if (this.field != null) {
            generator.writeKey("field");
            generator.write(this.field);
        }
        if (this.interval != null) {
            generator.writeKey("interval");
            generator.write(this.interval.doubleValue());
        }
        if (this.minDocCount != null) {
            generator.writeKey("min_doc_count");
            generator.write(this.minDocCount.intValue());
        }
        if (this.missing != null) {
            generator.writeKey("missing");
            generator.write(this.missing.doubleValue());
        }
        if (this.offset != null) {
            generator.writeKey("offset");
            generator.write(this.offset.doubleValue());
        }
        if (this.order != null) {
            generator.writeKey("order");
            this.order.serialize(generator, mapper);
        }
        if (this.script != null) {
            generator.writeKey("script");
            this.script.serialize(generator, mapper);
        }
        if (this.format != null) {
            generator.writeKey("format");
            generator.write(this.format);
        }
        if (this.keyed != null) {
            generator.writeKey("keyed");
            generator.write(this.keyed.booleanValue());
        }
    }

    protected static void setupHistogramAggregationDeserializer(ObjectDeserializer<Builder> op) {
        HistogramAggregation.setupBucketAggregationBaseDeserializer(op);
        op.add(Builder::extendedBounds, ExtendedBounds.createExtendedBoundsDeserializer(JsonpDeserializer.doubleDeserializer()), "extended_bounds");
        op.add(Builder::hardBounds, ExtendedBounds.createExtendedBoundsDeserializer(JsonpDeserializer.doubleDeserializer()), "hard_bounds");
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::interval, JsonpDeserializer.doubleDeserializer(), "interval");
        op.add(Builder::minDocCount, JsonpDeserializer.integerDeserializer(), "min_doc_count");
        op.add(Builder::missing, JsonpDeserializer.doubleDeserializer(), "missing");
        op.add(Builder::offset, JsonpDeserializer.doubleDeserializer(), "offset");
        op.add(Builder::order, HistogramOrder._DESERIALIZER, "order");
        op.add(Builder::script, Script._DESERIALIZER, "script");
        op.add(Builder::format, JsonpDeserializer.stringDeserializer(), "format");
        op.add(Builder::keyed, JsonpDeserializer.booleanDeserializer(), "keyed");
    }

    public static class Builder
    extends BucketAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<HistogramAggregation> {
        @Nullable
        private ExtendedBounds<Double> extendedBounds;
        @Nullable
        private ExtendedBounds<Double> hardBounds;
        @Nullable
        private String field;
        @Nullable
        private Double interval;
        @Nullable
        private Integer minDocCount;
        @Nullable
        private Double missing;
        @Nullable
        private Double offset;
        @Nullable
        private HistogramOrder order;
        @Nullable
        private Script script;
        @Nullable
        private String format;
        @Nullable
        private Boolean keyed;

        public final Builder extendedBounds(@Nullable ExtendedBounds<Double> value) {
            this.extendedBounds = value;
            return this;
        }

        public final Builder extendedBounds(Function<ExtendedBounds.Builder<Double>, ObjectBuilder<ExtendedBounds<Double>>> fn) {
            return this.extendedBounds(fn.apply(new ExtendedBounds.Builder()).build());
        }

        public final Builder hardBounds(@Nullable ExtendedBounds<Double> value) {
            this.hardBounds = value;
            return this;
        }

        public final Builder hardBounds(Function<ExtendedBounds.Builder<Double>, ObjectBuilder<ExtendedBounds<Double>>> fn) {
            return this.hardBounds(fn.apply(new ExtendedBounds.Builder()).build());
        }

        public final Builder field(@Nullable String value) {
            this.field = value;
            return this;
        }

        public final Builder interval(@Nullable Double value) {
            this.interval = value;
            return this;
        }

        public final Builder minDocCount(@Nullable Integer value) {
            this.minDocCount = value;
            return this;
        }

        public final Builder missing(@Nullable Double value) {
            this.missing = value;
            return this;
        }

        public final Builder offset(@Nullable Double value) {
            this.offset = value;
            return this;
        }

        public final Builder order(@Nullable HistogramOrder value) {
            this.order = value;
            return this;
        }

        public final Builder order(Function<HistogramOrder.Builder, ObjectBuilder<HistogramOrder>> fn) {
            return this.order(fn.apply(new HistogramOrder.Builder()).build());
        }

        public final Builder script(@Nullable Script value) {
            this.script = value;
            return this;
        }

        public final Builder script(Function<Script.Builder, ObjectBuilder<Script>> fn) {
            return this.script(fn.apply(new Script.Builder()).build());
        }

        public final Builder format(@Nullable String value) {
            this.format = value;
            return this;
        }

        public final Builder keyed(@Nullable Boolean value) {
            this.keyed = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public HistogramAggregation build() {
            this._checkSingleUse();
            return new HistogramAggregation(this);
        }
    }
}

