/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Optional;
import org.apache.james.mailbox.model.Cid;
import org.apache.james.mailbox.model.StringBackedAttachmentId;

public class MessageAttachmentRepresentation {
    private final StringBackedAttachmentId attachmentId;
    private final Optional<String> name;
    private final Optional<Cid> cid;
    private final boolean isInline;

    public static Builder builder() {
        return new Builder();
    }

    @VisibleForTesting
    MessageAttachmentRepresentation(StringBackedAttachmentId attachmentId, Optional<String> name, Optional<Cid> cid, boolean isInline) {
        this.attachmentId = attachmentId;
        this.name = name;
        this.cid = cid;
        this.isInline = isInline;
    }

    public StringBackedAttachmentId getAttachmentId() {
        return this.attachmentId;
    }

    public Optional<String> getName() {
        return this.name;
    }

    public Optional<Cid> getCid() {
        return this.cid;
    }

    public boolean isInline() {
        return this.isInline;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MessageAttachmentRepresentation) {
            MessageAttachmentRepresentation other = (MessageAttachmentRepresentation)obj;
            return Objects.equal((Object)this.attachmentId, (Object)other.attachmentId) && Objects.equal(this.name, other.name) && Objects.equal(this.cid, other.cid) && Objects.equal((Object)this.isInline, (Object)other.isInline);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.attachmentId, this.name, this.cid, this.isInline});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("attachmentId", (Object)this.attachmentId).add("name", this.name).add("cid", this.cid).add("isInline", this.isInline).toString();
    }

    public static class Builder {
        private StringBackedAttachmentId attachmentId;
        private Optional<String> name = Optional.empty();
        private Optional<Cid> cid = Optional.empty();
        private Optional<Boolean> isInline = Optional.empty();

        private Builder() {
        }

        public Builder attachmentId(StringBackedAttachmentId attachmentId) {
            Preconditions.checkArgument((attachmentId != null ? 1 : 0) != 0);
            this.attachmentId = attachmentId;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        public Builder cid(Optional<Cid> cid) {
            Preconditions.checkNotNull(cid);
            this.cid = cid;
            return this;
        }

        public Builder cid(Cid cid) {
            this.cid = Optional.ofNullable(cid);
            return this;
        }

        public Builder isInline(boolean isInline) {
            this.isInline = Optional.of(isInline);
            return this;
        }

        public MessageAttachmentRepresentation build() {
            Preconditions.checkState((this.attachmentId != null ? 1 : 0) != 0, (Object)"'attachmentId' is mandatory");
            boolean builtIsInLine = this.isInline.orElse(false);
            return new MessageAttachmentRepresentation(this.attachmentId, this.name, this.cid, builtIsInLine);
        }
    }
}

