/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service.metrics;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.iotdb.commons.client.ClientManagerMetrics;
import org.apache.iotdb.commons.concurrent.ThreadModule;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.concurrent.ThreadPoolMetrics;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.service.metric.JvmGcMonitorMetrics;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.commons.service.metric.PerformanceOverviewMetrics;
import org.apache.iotdb.commons.service.metric.cpu.CpuUsageMetrics;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.pipe.metric.PipeDataNodeMetrics;
import org.apache.iotdb.db.protocol.thrift.handler.RPCServiceThriftHandlerMetrics;
import org.apache.iotdb.db.queryengine.metric.DataExchangeCostMetricSet;
import org.apache.iotdb.db.queryengine.metric.DataExchangeCountMetricSet;
import org.apache.iotdb.db.queryengine.metric.DriverSchedulerMetricSet;
import org.apache.iotdb.db.queryengine.metric.QueryExecutionMetricSet;
import org.apache.iotdb.db.queryengine.metric.QueryPlanCostMetricSet;
import org.apache.iotdb.db.queryengine.metric.QueryRelatedResourceMetricSet;
import org.apache.iotdb.db.queryengine.metric.QueryResourceMetricSet;
import org.apache.iotdb.db.queryengine.metric.SeriesScanCostMetricSet;
import org.apache.iotdb.db.service.metrics.CompactionMetrics;
import org.apache.iotdb.db.service.metrics.FileMetrics;
import org.apache.iotdb.db.service.metrics.ProcessMetrics;
import org.apache.iotdb.db.service.metrics.WritingMetrics;
import org.apache.iotdb.db.service.metrics.memory.GlobalMemoryMetrics;
import org.apache.iotdb.db.storageengine.load.metrics.ActiveLoadingFilesNumberMetricsSet;
import org.apache.iotdb.db.storageengine.load.metrics.ActiveLoadingFilesSizeMetricsSet;
import org.apache.iotdb.db.storageengine.load.metrics.LoadTsFileCostMetricsSet;
import org.apache.iotdb.db.storageengine.load.metrics.LoadTsFileMemMetricSet;
import org.apache.iotdb.db.subscription.metric.SubscriptionMetrics;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.metricsets.UpTimeMetrics;
import org.apache.iotdb.metrics.metricsets.disk.DiskMetrics;
import org.apache.iotdb.metrics.metricsets.jvm.JvmMetrics;
import org.apache.iotdb.metrics.metricsets.logback.LogbackMetrics;
import org.apache.iotdb.metrics.metricsets.net.NetMetrics;
import org.apache.iotdb.metrics.metricsets.system.SystemMetrics;

public class DataNodeMetricsHelper {
    public static void bind() {
        MetricService metricService = MetricService.getInstance();
        metricService.addMetricSet((IMetricSet)new UpTimeMetrics());
        metricService.addMetricSet((IMetricSet)new JvmMetrics());
        metricService.addMetricSet((IMetricSet)ThreadPoolMetrics.getInstance());
        metricService.addMetricSet((IMetricSet)new LogbackMetrics());
        metricService.addMetricSet((IMetricSet)FileMetrics.getInstance());
        metricService.addMetricSet((IMetricSet)CompactionMetrics.getInstance());
        metricService.addMetricSet((IMetricSet)new ProcessMetrics());
        metricService.addMetricSet((IMetricSet)new DiskMetrics("datanode"));
        metricService.addMetricSet((IMetricSet)new NetMetrics("datanode"));
        metricService.addMetricSet((IMetricSet)ClientManagerMetrics.getInstance());
        metricService.addMetricSet((IMetricSet)RPCServiceThriftHandlerMetrics.getInstance());
        DataNodeMetricsHelper.initCpuMetrics(metricService);
        DataNodeMetricsHelper.initSystemMetrics(metricService);
        metricService.addMetricSet((IMetricSet)WritingMetrics.getInstance());
        metricService.addMetricSet((IMetricSet)QueryPlanCostMetricSet.getInstance());
        metricService.addMetricSet((IMetricSet)SeriesScanCostMetricSet.getInstance());
        metricService.addMetricSet((IMetricSet)QueryExecutionMetricSet.getInstance());
        metricService.addMetricSet((IMetricSet)QueryResourceMetricSet.getInstance());
        metricService.addMetricSet((IMetricSet)DataExchangeCostMetricSet.getInstance());
        metricService.addMetricSet((IMetricSet)DataExchangeCountMetricSet.getInstance());
        metricService.addMetricSet((IMetricSet)DriverSchedulerMetricSet.getInstance());
        metricService.addMetricSet((IMetricSet)QueryRelatedResourceMetricSet.getInstance());
        metricService.addMetricSet((IMetricSet)PerformanceOverviewMetrics.getInstance());
        metricService.addMetricSet((IMetricSet)JvmGcMonitorMetrics.getInstance());
        metricService.addMetricSet((IMetricSet)PipeDataNodeMetrics.getInstance());
        metricService.addMetricSet((IMetricSet)LoadTsFileMemMetricSet.getInstance());
        metricService.addMetricSet((IMetricSet)SubscriptionMetrics.getInstance());
        metricService.addMetricSet((IMetricSet)LoadTsFileCostMetricsSet.getInstance());
        metricService.addMetricSet((IMetricSet)ActiveLoadingFilesNumberMetricsSet.getInstance());
        metricService.addMetricSet((IMetricSet)ActiveLoadingFilesSizeMetricsSet.getInstance());
        metricService.addMetricSet((IMetricSet)GlobalMemoryMetrics.getInstance());
    }

    private static void initSystemMetrics(MetricService metricService) {
        ArrayList<String> diskDirs = new ArrayList<String>();
        diskDirs.add(IoTDBDescriptor.getInstance().getConfig().getSystemDir());
        diskDirs.add(IoTDBDescriptor.getInstance().getConfig().getConsensusDir());
        diskDirs.addAll(Arrays.asList(IoTDBDescriptor.getInstance().getConfig().getDataDirs()));
        diskDirs.addAll(Arrays.asList(CommonDescriptor.getInstance().getConfig().getWalDirs()));
        diskDirs.add(CommonDescriptor.getInstance().getConfig().getSyncDir());
        diskDirs.add(IoTDBDescriptor.getInstance().getConfig().getSortTmpDir());
        SystemMetrics.getInstance().setDiskDirs(diskDirs);
        metricService.addMetricSet((IMetricSet)SystemMetrics.getInstance());
    }

    private static void initCpuMetrics(MetricService metricService) {
        ArrayList threadModules = new ArrayList();
        Arrays.stream(ThreadModule.values()).forEach(x -> threadModules.add(x.toString()));
        ArrayList pools = new ArrayList();
        Arrays.stream(ThreadName.values()).forEach(x -> pools.add(x.name()));
        metricService.addMetricSet((IMetricSet)new CpuUsageMetrics(threadModules, pools, x -> ThreadName.getModuleTheThreadBelongs((String)x).toString(), x -> ThreadName.getThreadPoolTheThreadBelongs((String)x).name()));
    }
}

