/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchlogs.model.Distribution;
import software.amazon.awssdk.services.cloudwatchlogs.model.EmitSystemFieldsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SubscriptionFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SubscriptionFilter> {
    private static final SdkField<String> FILTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("filterName").getter(SubscriptionFilter.getter(SubscriptionFilter::filterName)).setter(SubscriptionFilter.setter(Builder::filterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterName").build()}).build();
    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logGroupName").getter(SubscriptionFilter.getter(SubscriptionFilter::logGroupName)).setter(SubscriptionFilter.setter(Builder::logGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupName").build()}).build();
    private static final SdkField<String> FILTER_PATTERN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("filterPattern").getter(SubscriptionFilter.getter(SubscriptionFilter::filterPattern)).setter(SubscriptionFilter.setter(Builder::filterPattern)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterPattern").build()}).build();
    private static final SdkField<String> DESTINATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destinationArn").getter(SubscriptionFilter.getter(SubscriptionFilter::destinationArn)).setter(SubscriptionFilter.setter(Builder::destinationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationArn").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(SubscriptionFilter.getter(SubscriptionFilter::roleArn)).setter(SubscriptionFilter.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> DISTRIBUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("distribution").getter(SubscriptionFilter.getter(SubscriptionFilter::distributionAsString)).setter(SubscriptionFilter.setter(Builder::distribution)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("distribution").build()}).build();
    private static final SdkField<Boolean> APPLY_ON_TRANSFORMED_LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("applyOnTransformedLogs").getter(SubscriptionFilter.getter(SubscriptionFilter::applyOnTransformedLogs)).setter(SubscriptionFilter.setter(Builder::applyOnTransformedLogs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applyOnTransformedLogs").build()}).build();
    private static final SdkField<Long> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("creationTime").getter(SubscriptionFilter.getter(SubscriptionFilter::creationTime)).setter(SubscriptionFilter.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<String> FIELD_SELECTION_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fieldSelectionCriteria").getter(SubscriptionFilter.getter(SubscriptionFilter::fieldSelectionCriteria)).setter(SubscriptionFilter.setter(Builder::fieldSelectionCriteria)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldSelectionCriteria").build()}).build();
    private static final SdkField<List<String>> EMIT_SYSTEM_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("emitSystemFields").getter(SubscriptionFilter.getter(SubscriptionFilter::emitSystemFields)).setter(SubscriptionFilter.setter(Builder::emitSystemFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("emitSystemFields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_NAME_FIELD, LOG_GROUP_NAME_FIELD, FILTER_PATTERN_FIELD, DESTINATION_ARN_FIELD, ROLE_ARN_FIELD, DISTRIBUTION_FIELD, APPLY_ON_TRANSFORMED_LOGS_FIELD, CREATION_TIME_FIELD, FIELD_SELECTION_CRITERIA_FIELD, EMIT_SYSTEM_FIELDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SubscriptionFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String filterName;
    private final String logGroupName;
    private final String filterPattern;
    private final String destinationArn;
    private final String roleArn;
    private final String distribution;
    private final Boolean applyOnTransformedLogs;
    private final Long creationTime;
    private final String fieldSelectionCriteria;
    private final List<String> emitSystemFields;

    private SubscriptionFilter(BuilderImpl builder) {
        this.filterName = builder.filterName;
        this.logGroupName = builder.logGroupName;
        this.filterPattern = builder.filterPattern;
        this.destinationArn = builder.destinationArn;
        this.roleArn = builder.roleArn;
        this.distribution = builder.distribution;
        this.applyOnTransformedLogs = builder.applyOnTransformedLogs;
        this.creationTime = builder.creationTime;
        this.fieldSelectionCriteria = builder.fieldSelectionCriteria;
        this.emitSystemFields = builder.emitSystemFields;
    }

    public final String filterName() {
        return this.filterName;
    }

    public final String logGroupName() {
        return this.logGroupName;
    }

    public final String filterPattern() {
        return this.filterPattern;
    }

    public final String destinationArn() {
        return this.destinationArn;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final Distribution distribution() {
        return Distribution.fromValue(this.distribution);
    }

    public final String distributionAsString() {
        return this.distribution;
    }

    public final Boolean applyOnTransformedLogs() {
        return this.applyOnTransformedLogs;
    }

    public final Long creationTime() {
        return this.creationTime;
    }

    public final String fieldSelectionCriteria() {
        return this.fieldSelectionCriteria;
    }

    public final boolean hasEmitSystemFields() {
        return this.emitSystemFields != null && !(this.emitSystemFields instanceof SdkAutoConstructList);
    }

    public final List<String> emitSystemFields() {
        return this.emitSystemFields;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterPattern());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.distributionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.applyOnTransformedLogs());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldSelectionCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEmitSystemFields() ? this.emitSystemFields() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubscriptionFilter)) {
            return false;
        }
        SubscriptionFilter other = (SubscriptionFilter)obj;
        return Objects.equals(this.filterName(), other.filterName()) && Objects.equals(this.logGroupName(), other.logGroupName()) && Objects.equals(this.filterPattern(), other.filterPattern()) && Objects.equals(this.destinationArn(), other.destinationArn()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.distributionAsString(), other.distributionAsString()) && Objects.equals(this.applyOnTransformedLogs(), other.applyOnTransformedLogs()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.fieldSelectionCriteria(), other.fieldSelectionCriteria()) && this.hasEmitSystemFields() == other.hasEmitSystemFields() && Objects.equals(this.emitSystemFields(), other.emitSystemFields());
    }

    public final String toString() {
        return ToString.builder((String)"SubscriptionFilter").add("FilterName", (Object)this.filterName()).add("LogGroupName", (Object)this.logGroupName()).add("FilterPattern", (Object)this.filterPattern()).add("DestinationArn", (Object)this.destinationArn()).add("RoleArn", (Object)this.roleArn()).add("Distribution", (Object)this.distributionAsString()).add("ApplyOnTransformedLogs", (Object)this.applyOnTransformedLogs()).add("CreationTime", (Object)this.creationTime()).add("FieldSelectionCriteria", (Object)this.fieldSelectionCriteria()).add("EmitSystemFields", this.hasEmitSystemFields() ? this.emitSystemFields() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "filterName": {
                return Optional.ofNullable(clazz.cast(this.filterName()));
            }
            case "logGroupName": {
                return Optional.ofNullable(clazz.cast(this.logGroupName()));
            }
            case "filterPattern": {
                return Optional.ofNullable(clazz.cast(this.filterPattern()));
            }
            case "destinationArn": {
                return Optional.ofNullable(clazz.cast(this.destinationArn()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "distribution": {
                return Optional.ofNullable(clazz.cast(this.distributionAsString()));
            }
            case "applyOnTransformedLogs": {
                return Optional.ofNullable(clazz.cast(this.applyOnTransformedLogs()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "fieldSelectionCriteria": {
                return Optional.ofNullable(clazz.cast(this.fieldSelectionCriteria()));
            }
            case "emitSystemFields": {
                return Optional.ofNullable(clazz.cast(this.emitSystemFields()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("filterName", FILTER_NAME_FIELD);
        map.put("logGroupName", LOG_GROUP_NAME_FIELD);
        map.put("filterPattern", FILTER_PATTERN_FIELD);
        map.put("destinationArn", DESTINATION_ARN_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("distribution", DISTRIBUTION_FIELD);
        map.put("applyOnTransformedLogs", APPLY_ON_TRANSFORMED_LOGS_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("fieldSelectionCriteria", FIELD_SELECTION_CRITERIA_FIELD);
        map.put("emitSystemFields", EMIT_SYSTEM_FIELDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SubscriptionFilter, T> g) {
        return obj -> g.apply((SubscriptionFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String filterName;
        private String logGroupName;
        private String filterPattern;
        private String destinationArn;
        private String roleArn;
        private String distribution;
        private Boolean applyOnTransformedLogs;
        private Long creationTime;
        private String fieldSelectionCriteria;
        private List<String> emitSystemFields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SubscriptionFilter model) {
            this.filterName(model.filterName);
            this.logGroupName(model.logGroupName);
            this.filterPattern(model.filterPattern);
            this.destinationArn(model.destinationArn);
            this.roleArn(model.roleArn);
            this.distribution(model.distribution);
            this.applyOnTransformedLogs(model.applyOnTransformedLogs);
            this.creationTime(model.creationTime);
            this.fieldSelectionCriteria(model.fieldSelectionCriteria);
            this.emitSystemFields(model.emitSystemFields);
        }

        public final String getFilterName() {
            return this.filterName;
        }

        public final void setFilterName(String filterName) {
            this.filterName = filterName;
        }

        @Override
        public final Builder filterName(String filterName) {
            this.filterName = filterName;
            return this;
        }

        public final String getLogGroupName() {
            return this.logGroupName;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final String getFilterPattern() {
            return this.filterPattern;
        }

        public final void setFilterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
        }

        @Override
        public final Builder filterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
            return this;
        }

        public final String getDestinationArn() {
            return this.destinationArn;
        }

        public final void setDestinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
        }

        @Override
        public final Builder destinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getDistribution() {
            return this.distribution;
        }

        public final void setDistribution(String distribution) {
            this.distribution = distribution;
        }

        @Override
        public final Builder distribution(String distribution) {
            this.distribution = distribution;
            return this;
        }

        @Override
        public final Builder distribution(Distribution distribution) {
            this.distribution(distribution == null ? null : distribution.toString());
            return this;
        }

        public final Boolean getApplyOnTransformedLogs() {
            return this.applyOnTransformedLogs;
        }

        public final void setApplyOnTransformedLogs(Boolean applyOnTransformedLogs) {
            this.applyOnTransformedLogs = applyOnTransformedLogs;
        }

        @Override
        public final Builder applyOnTransformedLogs(Boolean applyOnTransformedLogs) {
            this.applyOnTransformedLogs = applyOnTransformedLogs;
            return this;
        }

        public final Long getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Long creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getFieldSelectionCriteria() {
            return this.fieldSelectionCriteria;
        }

        public final void setFieldSelectionCriteria(String fieldSelectionCriteria) {
            this.fieldSelectionCriteria = fieldSelectionCriteria;
        }

        @Override
        public final Builder fieldSelectionCriteria(String fieldSelectionCriteria) {
            this.fieldSelectionCriteria = fieldSelectionCriteria;
            return this;
        }

        public final Collection<String> getEmitSystemFields() {
            if (this.emitSystemFields instanceof SdkAutoConstructList) {
                return null;
            }
            return this.emitSystemFields;
        }

        public final void setEmitSystemFields(Collection<String> emitSystemFields) {
            this.emitSystemFields = EmitSystemFieldsCopier.copy(emitSystemFields);
        }

        @Override
        public final Builder emitSystemFields(Collection<String> emitSystemFields) {
            this.emitSystemFields = EmitSystemFieldsCopier.copy(emitSystemFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder emitSystemFields(String ... emitSystemFields) {
            this.emitSystemFields(Arrays.asList(emitSystemFields));
            return this;
        }

        public SubscriptionFilter build() {
            return new SubscriptionFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SubscriptionFilter> {
        public Builder filterName(String var1);

        public Builder logGroupName(String var1);

        public Builder filterPattern(String var1);

        public Builder destinationArn(String var1);

        public Builder roleArn(String var1);

        public Builder distribution(String var1);

        public Builder distribution(Distribution var1);

        public Builder applyOnTransformedLogs(Boolean var1);

        public Builder creationTime(Long var1);

        public Builder fieldSelectionCriteria(String var1);

        public Builder emitSystemFields(Collection<String> var1);

        public Builder emitSystemFields(String ... var1);
    }
}

