/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.entity;

import java.io.Serializable;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.raft.Peer;
import org.apache.ignite3.raft.jraft.entity.Checksum;
import org.apache.ignite3.raft.jraft.util.AsciiStringUtil;
import org.apache.ignite3.raft.jraft.util.Copiable;
import org.apache.ignite3.raft.jraft.util.CrcUtil;
import org.apache.ignite3.raft.jraft.util.Utils;
import org.jetbrains.annotations.Nullable;

public class PeerId
implements Copiable<PeerId>,
Serializable,
Checksum {
    private static final long serialVersionUID = 8083529734784884641L;
    private static final IgniteLogger LOG = Loggers.forClass(PeerId.class);
    private String consistentId = "";
    private int idx;
    private String str;
    private int priority = -1;
    private long checksum;

    public PeerId() {
    }

    @Override
    public long checksum() {
        if (this.checksum == 0L) {
            this.checksum = CrcUtil.crc64(AsciiStringUtil.unsafeEncode(this.toString()));
        }
        return this.checksum;
    }

    public static PeerId emptyPeer() {
        return new PeerId();
    }

    @Override
    public PeerId copy() {
        return new PeerId(this.consistentId, this.idx, this.priority);
    }

    public static PeerId parsePeer(String s) {
        PeerId peer = new PeerId();
        if (peer.parse(s)) {
            return peer;
        }
        return null;
    }

    public PeerId(String consistentId) {
        this.consistentId = consistentId;
    }

    public PeerId(String consistentId, int idx) {
        this.consistentId = consistentId;
        this.idx = idx;
    }

    public PeerId(String consistentId, int idx, int priority) {
        this.consistentId = consistentId;
        this.idx = idx;
        this.priority = priority;
    }

    public String getConsistentId() {
        return this.consistentId;
    }

    public int getIdx() {
        return this.idx;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
        this.str = null;
    }

    public boolean isEmpty() {
        return this.consistentId.isEmpty() && this.idx == 0;
    }

    public String toString() {
        if (this.str == null) {
            StringBuilder buf = new StringBuilder(this.consistentId);
            if (this.idx != 0) {
                buf.append(':').append(this.idx);
            }
            if (this.priority != -1) {
                if (this.idx == 0) {
                    buf.append(':');
                }
                buf.append(':').append(this.priority);
            }
            this.str = buf.toString();
        }
        return this.str;
    }

    public boolean parse(String s) {
        if (s == null) {
            return false;
        }
        if (s.isEmpty()) {
            return true;
        }
        String[] tmps = Utils.parsePeerId(s);
        if (tmps.length < 1 || tmps.length > 3) {
            return false;
        }
        try {
            this.consistentId = tmps[0];
            switch (tmps.length) {
                case 2: {
                    this.idx = Integer.parseInt(tmps[1]);
                    break;
                }
                case 3: {
                    this.idx = tmps[1].isEmpty() ? 0 : Integer.parseInt(tmps[1]);
                    this.priority = Integer.parseInt(tmps[2]);
                    break;
                }
            }
            this.str = null;
            return true;
        }
        catch (Exception e) {
            LOG.error("Parse peer from string failed: {}.", e, s);
            return false;
        }
    }

    public boolean isPriorityNotElected() {
        return this.priority == 0;
    }

    public boolean isPriorityDisabled() {
        return this.priority <= -1;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.consistentId.hashCode();
        result = 31 * result + this.idx;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PeerId other = (PeerId)obj;
        if (!this.consistentId.equals(other.consistentId)) {
            return false;
        }
        return this.idx == other.idx;
    }

    @Nullable
    public static PeerId fromPeer(@Nullable Peer p) {
        if (p == null) {
            return null;
        }
        return new PeerId(p.consistentId(), p.idx());
    }
}

