/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.mapping.largecluster;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import org.apache.calcite.util.BitSets;
import org.apache.ignite.internal.sql.engine.exec.NodeWithConsistencyToken;
import org.apache.ignite.internal.sql.engine.exec.mapping.ColocationMappingException;
import org.apache.ignite.internal.sql.engine.exec.mapping.ExecutionTarget;
import org.apache.ignite.internal.sql.engine.exec.mapping.largecluster.AllOfTarget;
import org.apache.ignite.internal.sql.engine.exec.mapping.largecluster.OneOfTarget;
import org.apache.ignite.internal.sql.engine.exec.mapping.largecluster.PartitionedTarget;
import org.apache.ignite.internal.sql.engine.exec.mapping.largecluster.SomeOfTarget;

abstract class AbstractTarget
implements ExecutionTarget {
    final BitSet nodes;

    AbstractTarget(BitSet nodes) {
        assert (!nodes.isEmpty()) : "Empty target is not allowed";
        this.nodes = nodes;
    }

    List<String> nodes(List<String> nodeNames) {
        int cardinality = this.nodes.cardinality();
        if (cardinality == 1) {
            int idx = this.nodes.nextSetBit(0);
            return List.of(nodeNames.get(idx));
        }
        ArrayList<String> result = new ArrayList<String>(cardinality);
        int idx = this.nodes.nextSetBit(0);
        while (idx >= 0) {
            result.add(nodeNames.get(idx));
            if (idx == Integer.MAX_VALUE) break;
            idx = this.nodes.nextSetBit(idx + 1);
        }
        return result;
    }

    Int2ObjectMap<NodeWithConsistencyToken> assignments(List<String> nodeNames) {
        if (!(this instanceof PartitionedTarget)) {
            return Int2ObjectMaps.emptyMap();
        }
        PartitionedTarget partitionedTarget = (PartitionedTarget)this;
        Int2ObjectOpenHashMap result = new Int2ObjectOpenHashMap(partitionedTarget.partitionsNodes.length);
        for (int partNo = 0; partNo < partitionedTarget.partitionsNodes.length; ++partNo) {
            BitSet partitionNodes = partitionedTarget.partitionsNodes[partNo];
            assert (partitionNodes.cardinality() == 1);
            int idx = partitionNodes.nextSetBit(0);
            result.put(partNo, (Object)new NodeWithConsistencyToken(nodeNames.get(idx), partitionedTarget.enlistmentConsistencyTokens[partNo]));
        }
        return result;
    }

    abstract ExecutionTarget finalise();

    abstract ExecutionTarget colocate(AllOfTarget var1) throws ColocationMappingException;

    abstract ExecutionTarget colocate(OneOfTarget var1) throws ColocationMappingException;

    abstract ExecutionTarget colocate(PartitionedTarget var1) throws ColocationMappingException;

    abstract ExecutionTarget colocate(SomeOfTarget var1) throws ColocationMappingException;

    static ExecutionTarget colocate(AllOfTarget allOf, AllOfTarget otherAllOf) throws ColocationMappingException {
        if (!allOf.nodes.equals(otherAllOf.nodes) || otherAllOf.nodes.cardinality() == 0) {
            throw new ColocationMappingException("Targets are not colocated");
        }
        return allOf;
    }

    static ExecutionTarget colocate(AllOfTarget allOf, OneOfTarget oneOf) throws ColocationMappingException {
        int target = allOf.nodes.nextSetBit(0);
        if (target == -1 || allOf.nodes.nextSetBit(target + 1) != -1 || !oneOf.nodes.get(target)) {
            throw new ColocationMappingException("Targets are not colocated");
        }
        return allOf;
    }

    static ExecutionTarget colocate(AllOfTarget allOf, PartitionedTarget partitioned) throws ColocationMappingException {
        throw new ColocationMappingException("AllOf target and Partitioned can't be colocated");
    }

    static ExecutionTarget colocate(AllOfTarget allOf, SomeOfTarget someOf) throws ColocationMappingException {
        if (!BitSets.contains((BitSet)someOf.nodes, (BitSet)allOf.nodes) || allOf.nodes.isEmpty()) {
            throw new ColocationMappingException("Targets are not colocated");
        }
        return allOf;
    }

    static ExecutionTarget colocate(OneOfTarget oneOf, OneOfTarget anotherOneOf) throws ColocationMappingException {
        BitSet newNodes = (BitSet)oneOf.nodes.clone();
        newNodes.and(anotherOneOf.nodes);
        if (newNodes.isEmpty()) {
            throw new ColocationMappingException("Targets are not colocated");
        }
        return new OneOfTarget(newNodes);
    }

    static ExecutionTarget colocate(OneOfTarget oneOf, PartitionedTarget partitioned) throws ColocationMappingException {
        if (partitioned.nodes.cardinality() == 1 && oneOf.nodes.get(partitioned.nodes.nextSetBit(0))) {
            return partitioned;
        }
        boolean changed = false;
        BitSet newNodes = (BitSet)oneOf.nodes.clone();
        for (int partNo = 0; partNo < partitioned.partitionsNodes.length; ++partNo) {
            if (newNodes.equals(partitioned.partitionsNodes[partNo])) continue;
            changed = true;
            newNodes.and(partitioned.partitionsNodes[partNo]);
            if (!newNodes.isEmpty()) continue;
            throw new ColocationMappingException("Targets are not colocated");
        }
        if (!changed) {
            return partitioned;
        }
        Object[] newPartitionsNodes = new BitSet[partitioned.partitionsNodes.length];
        Arrays.fill(newPartitionsNodes, newNodes);
        boolean finalised = newNodes.cardinality() == 1;
        return new PartitionedTarget(finalised, (BitSet[])newPartitionsNodes, partitioned.enlistmentConsistencyTokens);
    }

    static ExecutionTarget colocate(OneOfTarget oneOf, SomeOfTarget someOf) throws ColocationMappingException {
        if (!oneOf.nodes.intersects(someOf.nodes)) {
            throw new ColocationMappingException("Targets are not colocated");
        }
        BitSet newNodes = (BitSet)oneOf.nodes.clone();
        newNodes.and(someOf.nodes);
        return new OneOfTarget(newNodes);
    }

    static ExecutionTarget colocate(PartitionedTarget partitioned, PartitionedTarget otherPartitioned) throws ColocationMappingException {
        if (partitioned.partitionsNodes.length != otherPartitioned.partitionsNodes.length) {
            throw new ColocationMappingException("Partitioned targets with not matching numbers of partitions are not colocated");
        }
        boolean changed = false;
        boolean finalised = true;
        BitSet[] newPartitionsNodes = new BitSet[partitioned.partitionsNodes.length];
        for (int partNo = 0; partNo < partitioned.partitionsNodes.length; ++partNo) {
            if (partitioned.partitionsNodes[partNo].equals(otherPartitioned.partitionsNodes[partNo])) {
                newPartitionsNodes[partNo] = partitioned.partitionsNodes[partNo];
                continue;
            }
            changed = true;
            BitSet newNodes = (BitSet)partitioned.partitionsNodes[partNo].clone();
            newNodes.and(otherPartitioned.partitionsNodes[partNo]);
            if (newNodes.isEmpty()) {
                throw new ColocationMappingException("Targets are not colocated");
            }
            newPartitionsNodes[partNo] = newNodes;
            finalised = finalised && newNodes.cardinality() == 1;
        }
        if (!Arrays.equals(partitioned.enlistmentConsistencyTokens, otherPartitioned.enlistmentConsistencyTokens)) {
            throw new ColocationMappingException("Partitioned targets have different terms");
        }
        if (changed) {
            return new PartitionedTarget(finalised, newPartitionsNodes, partitioned.enlistmentConsistencyTokens);
        }
        return partitioned;
    }

    static ExecutionTarget colocate(PartitionedTarget partitioned, SomeOfTarget someOf) throws ColocationMappingException {
        boolean finalised = true;
        BitSet[] newPartitionsNodes = new BitSet[partitioned.partitionsNodes.length];
        for (int partNo = 0; partNo < partitioned.partitionsNodes.length; ++partNo) {
            BitSet newNodes = (BitSet)partitioned.partitionsNodes[partNo].clone();
            newNodes.and(someOf.nodes);
            if (newNodes.isEmpty()) {
                throw new ColocationMappingException("Targets are not colocated");
            }
            newPartitionsNodes[partNo] = newNodes;
            finalised = finalised && newNodes.cardinality() == 1;
        }
        return new PartitionedTarget(finalised, newPartitionsNodes, partitioned.enlistmentConsistencyTokens);
    }

    static ExecutionTarget colocate(SomeOfTarget someOf, SomeOfTarget otherSomeOf) throws ColocationMappingException {
        BitSet newNodes = (BitSet)someOf.nodes.clone();
        newNodes.and(otherSomeOf.nodes);
        if (newNodes.isEmpty()) {
            throw new ColocationMappingException("Targets are not colocated");
        }
        return new SomeOfTarget(newNodes);
    }

    static BitSet pickOne(BitSet nodes) {
        int node = nodes.nextSetBit(0);
        return node == -1 ? BitSets.of((int[])new int[0]) : BitSets.of((int[])new int[]{node});
    }
}

