/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.cli;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.core.annotation.TypeHint;
import io.micronaut.inject.BeanDefinition;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import org.grails.forge.cli.CodeGenConfig;
import org.grails.forge.cli.CommonOptionsMixin;
import org.grails.forge.cli.GrailsPicocliFactory;
import org.grails.forge.cli.InteractiveShell;
import org.grails.forge.cli.command.BaseCommand;
import org.grails.forge.cli.command.CodeGenCommand;
import org.grails.forge.cli.command.CreateAppCommand;
import org.grails.forge.cli.command.CreatePluginCommand;
import org.grails.forge.cli.command.CreateRestApiCommand;
import org.grails.forge.cli.command.CreateWebPluginCommand;
import org.grails.forge.cli.command.CreateWebappCommand;
import org.grails.forge.cli.command.GormImplCandidates;
import org.grails.forge.cli.command.GormImplConverter;
import org.grails.forge.cli.command.ServletImplCandidates;
import org.grails.forge.cli.command.ServletImplConverter;
import org.grails.forge.cli.command.TestFrameworkCandidates;
import org.grails.forge.cli.command.TestFrameworkConverter;
import org.grails.forge.io.ConsoleOutput;
import picocli.CommandLine;

@CommandLine.Command(name="grails-forge-cli", description={"Grails Forge CLI command line interface for generating projects and services.", "Application generation commands are:", "", "*  @|bold create-app|@ @|yellow NAME|@", "*  @|bold create-webapp|@ @|yellow NAME|@", "*  @|bold create-restapi|@ @|yellow NAME|@", "*  @|bold create-plugin|@ @|yellow NAME|@", "*  @|bold create-web-plugin|@ @|yellow NAME|@"}, synopsisHeading="@|bold,underline Usage:|@ ", optionListHeading="%n@|bold,underline Options:|@%n", commandListHeading="%n@|bold,underline Commands:|@%n", subcommands={CreateAppCommand.class, CreateWebappCommand.class, CreatePluginCommand.class, CreateWebPluginCommand.class, CreateRestApiCommand.class})
@Prototype
@TypeHint(value={Application.class, GormImplCandidates.class, GormImplConverter.class, ServletImplCandidates.class, ServletImplConverter.class, CommonOptionsMixin.class, TestFrameworkCandidates.class, TestFrameworkConverter.class})
public class Application
extends BaseCommand
implements Callable<Integer> {
    private static Boolean interactiveShell = false;
    private static final BiFunction<Throwable, CommandLine, Integer> EXCEPTION_HANDLER = (e, commandLine) -> {
        BaseCommand command = (BaseCommand)commandLine.getCommand();
        command.err(e.getMessage());
        if (command.showStacktrace()) {
            e.printStackTrace(commandLine.getErr());
        }
        return 1;
    };

    public static void main(String[] args) {
        if (args.length == 0) {
            CommandLine commandLine = Application.createCommandLine();
            interactiveShell = true;
            new InteractiveShell(commandLine, Application::execute, EXCEPTION_HANDLER).start();
        } else {
            System.exit(Application.execute(args));
        }
    }

    static CommandLine createCommandLine() {
        boolean noOpConsole = interactiveShell;
        try (ApplicationContext beanContext = ApplicationContext.builder().deduceEnvironment(false).start();){
            CommandLine commandLine = Application.createCommandLine(beanContext, noOpConsole);
            return commandLine;
        }
    }

    static int execute(String[] args) {
        boolean noOpConsole = args.length > 0 && args[0].startsWith("update-cli-config");
        try (ApplicationContext beanContext = ApplicationContext.builder().deduceEnvironment(false).start();){
            int n = Application.createCommandLine(beanContext, noOpConsole).execute(args);
            return n;
        }
    }

    private static CommandLine createCommandLine(BeanContext beanContext, boolean noOpConsole) {
        Application application2 = beanContext.getBean(Application.class);
        CommandLine commandLine = new CommandLine(application2, new GrailsPicocliFactory(beanContext));
        commandLine.setExecutionExceptionHandler((ex, commandLine1, parseResult) -> EXCEPTION_HANDLER.apply(ex, commandLine1));
        commandLine.setUsageHelpWidth(100);
        CodeGenConfig codeGenConfig = CodeGenConfig.load(beanContext, noOpConsole ? ConsoleOutput.NOOP : application2);
        if (codeGenConfig != null) {
            beanContext.getBeanDefinitions(CodeGenCommand.class).stream().map(BeanDefinition::getBeanType).map(bt -> (CodeGenCommand)beanContext.createBean(bt, codeGenConfig)).filter(CodeGenCommand::applies).forEach(commandLine::addSubcommand);
        }
        return commandLine;
    }

    @Override
    public Integer call() throws Exception {
        throw new CommandLine.ParameterException(this.spec.commandLine(), "No command specified");
    }
}

