/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.function.BiConsumer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.StreamingHttpOutputMessage;
import org.springframework.http.client.AbstractStreamingClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.SimpleClientHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

final class SimpleClientHttpRequest
extends AbstractStreamingClientHttpRequest {
    private final HttpURLConnection connection;
    private final int chunkSize;

    SimpleClientHttpRequest(HttpURLConnection connection, int chunkSize) {
        this.connection = connection;
        this.chunkSize = chunkSize;
    }

    @Override
    public HttpMethod getMethod() {
        return HttpMethod.valueOf(this.connection.getRequestMethod());
    }

    @Override
    public URI getURI() {
        try {
            return this.connection.getURL().toURI();
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException("Could not get HttpURLConnection URI: " + ex.getMessage(), ex);
        }
    }

    @Override
    protected ClientHttpResponse executeInternal(HttpHeaders headers, @Nullable StreamingHttpOutputMessage.Body body2) throws IOException {
        if (this.connection.getDoOutput()) {
            long contentLength = headers.getContentLength();
            if (contentLength >= 0L) {
                this.connection.setFixedLengthStreamingMode(contentLength);
            } else {
                this.connection.setChunkedStreamingMode(this.chunkSize);
            }
        }
        SimpleClientHttpRequest.addHeaders(this.connection, headers);
        this.connection.connect();
        if (this.connection.getDoOutput() && body2 != null) {
            try (OutputStream os = this.connection.getOutputStream();){
                body2.writeTo(os);
            }
        } else {
            this.connection.getResponseCode();
        }
        return new SimpleClientHttpResponse(this.connection);
    }

    static void addHeaders(HttpURLConnection connection, HttpHeaders headers) {
        String method = connection.getRequestMethod();
        if ((method.equals("PUT") || method.equals("DELETE")) && !StringUtils.hasText(headers.getFirst("Accept"))) {
            headers.set("Accept", "*/*");
        }
        headers.forEach((BiConsumer<? super String, ? super List<String>>)((BiConsumer<String, List>)(headerName, headerValues) -> {
            if ("Cookie".equalsIgnoreCase((String)headerName)) {
                String headerValue = StringUtils.collectionToDelimitedString(headerValues, "; ");
                connection.setRequestProperty((String)headerName, headerValue);
            } else {
                for (String headerValue : headerValues) {
                    String actualHeaderValue = headerValue != null ? headerValue : "";
                    connection.addRequestProperty((String)headerName, actualHeaderValue);
                }
            }
        }));
    }
}

