/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.options;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public enum JdkVersion {
    JDK_17(17),
    JDK_21(21),
    JDK_24(24);

    public static final JdkVersion DEFAULT_OPTION;
    private static final List<Integer> SUPPORTED_JDKS;
    private final int majorVersion;

    private JdkVersion(int majorVersion) {
        this.majorVersion = majorVersion;
    }

    public static JdkVersion valueOf(int majorVersion) {
        return Arrays.stream(JdkVersion.values()).filter(jdkVersion -> jdkVersion.majorVersion == majorVersion).findFirst().orElseThrow(() -> new IllegalArgumentException("Unsupported JDK version: " + majorVersion + ". Supported values are " + String.valueOf(SUPPORTED_JDKS)));
    }

    public int majorVersion() {
        return this.majorVersion;
    }

    static {
        DEFAULT_OPTION = JDK_17;
        SUPPORTED_JDKS = Arrays.stream(JdkVersion.values()).map(JdkVersion::majorVersion).collect(Collectors.toList());
    }
}

