/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.profile.logic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.saml.metadata.EntityGroupName;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.saml2.metadata.AffiliateMember;
import org.opensaml.saml.saml2.metadata.AffiliationDescriptor;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.slf4j.Logger;

public class EntityGroupNamePredicate
implements Predicate<EntityDescriptor> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(EntityGroupNamePredicate.class);
    @Nonnull
    private final Set<String> groupNames;
    @Nullable
    private MetadataResolver metadataResolver;
    @Nullable
    private Collection<CriteriaSet> criteriaSets;

    public EntityGroupNamePredicate(@Nullable @ParameterName(name="names") Collection<String> names) {
        this(names, null);
    }

    public EntityGroupNamePredicate(@Nullable @ParameterName(name="names") Collection<String> names, @Nullable @ParameterName(name="resolver") MetadataResolver resolver) {
        this.groupNames = CollectionSupport.copyToSet((Collection)StringSupport.normalizeStringCollection(names));
        this.metadataResolver = resolver;
        if (resolver != null) {
            this.criteriaSets = new ArrayList<CriteriaSet>(this.groupNames.size());
            for (String name : this.groupNames) {
                assert (name != null);
                assert (this.criteriaSets != null);
                this.criteriaSets.add(new CriteriaSet(new Criterion[]{new EntityIdCriterion(name)}));
            }
        }
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public Set<String> getGroupNames() {
        return this.groupNames;
    }

    @Override
    public boolean test(@Nullable EntityDescriptor input) {
        if (input == null) {
            this.log.debug("Input was null, condition is false");
            return false;
        }
        for (EntityGroupName group : input.getObjectMetadata().get(EntityGroupName.class)) {
            if (!this.groupNames.contains(group.getName())) continue;
            this.log.debug("Found matching group '{}' attached to entity '{}'", (Object)group.getName(), (Object)input.getEntityID());
            return true;
        }
        if (this.metadataResolver != null) {
            assert (this.criteriaSets != null);
            for (CriteriaSet criteria : this.criteriaSets) {
                try {
                    AffiliationDescriptor descriptor;
                    assert (this.metadataResolver != null);
                    EntityDescriptor affiliation = (EntityDescriptor)this.metadataResolver.resolveSingle(criteria);
                    if (affiliation == null || (descriptor = affiliation.getAffiliationDescriptor()) == null) continue;
                    for (AffiliateMember member : descriptor.getMembers()) {
                        String uri = member.getURI();
                        if (uri == null || !uri.equals(input.getEntityID())) continue;
                        this.log.debug("Found AffiliationDescriptor '{}' membership for entity '{}'", (Object)affiliation.getEntityID(), (Object)input.getEntityID());
                        return true;
                    }
                }
                catch (ResolverException e) {
                    this.log.warn("Metadata lookup for AffiliationDescriptor failed", (Throwable)e);
                }
            }
        }
        this.log.debug("No group match found for entity '{}'", (Object)input.getEntityID());
        return false;
    }
}

