/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines;

import java.util.regex.Pattern;
import org.apache.commons.validator.routines.ISBNValidator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ISBNValidatorTest {
    private final String[] validISBN10Format = new String[]{"1234567890", "123456789X", "12345-1234567-123456-X", "12345 1234567 123456 X", "1-2-3-4", "1 2 3 4"};
    private final String[] invalidISBN10Format = new String[]{"", "   ", "1", "123456789", "12345678901", "12345678X0", "123456-1234567-123456-X", "12345-12345678-123456-X", "12345-1234567-1234567-X", "12345-1234567-123456-X2", "--1 930110 99 5", "1 930110 99 5--", "1 930110-99 5-", "1.2.3.4", "1=2=3=4", "1_2_3_4", "123456789Y", "dsasdsadsa", "I love sparrows!", "068-556-98-45"};
    private final String[] validISBN13Format = new String[]{"9781234567890", "9791234567890", "978-12345-1234567-123456-1", "979-12345-1234567-123456-1", "978 12345 1234567 123456 1", "979 12345 1234567 123456 1", "978-1-2-3-4", "979-1-2-3-4", "978 1 2 3 4", "979 1 2 3 4"};
    private final String[] invalidISBN13Format = new String[]{"", "   ", "1", "978123456789", "97812345678901", "978-123456-1234567-123456-1", "978-12345-12345678-123456-1", "978-12345-1234567-1234567-1", "978-12345-1234567-123456-12", "--978 1 930110 99 1", "978 1 930110 99 1--", "978 1 930110-99 1-", "123-4-567890-12-8", "978.1.2.3.4", "978=1=2=3=4", "978_1_2_3_4", "978123456789X", "978-0-201-63385-X", "dsasdsadsadsa", "I love sparrows!", "979-1-234-567-89-6"};

    ISBNValidatorTest() {
    }

    @Test
    void testConversionErrors() {
        ISBNValidator validator = ISBNValidator.getInstance();
        String input1 = "123456789 ";
        Assertions.assertThrows(IllegalArgumentException.class, () -> validator.convertToISBN13("123456789 "), (String)"Expected IllegalArgumentException for '123456789 '");
        String input2 = "12345678901";
        Assertions.assertThrows(IllegalArgumentException.class, () -> validator.convertToISBN13("12345678901"), (String)"Expected IllegalArgumentException for '12345678901'");
        String input3 = "";
        Assertions.assertThrows(IllegalArgumentException.class, () -> validator.convertToISBN13(""), (String)"Expected IllegalArgumentException for ''");
        String input4 = "X234567890";
        Assertions.assertThrows(IllegalArgumentException.class, () -> validator.convertToISBN13("X234567890"), (String)"Expected IllegalArgumentException for 'X234567890'");
    }

    @Test
    void testInvalid() {
        ISBNValidator validator = ISBNValidator.getInstance();
        String baseCode = "193011099";
        Assertions.assertFalse((boolean)validator.isValid(baseCode + "0"), (String)"ISBN10-0");
        Assertions.assertFalse((boolean)validator.isValid(baseCode + "1"), (String)"ISBN10-1");
        Assertions.assertFalse((boolean)validator.isValid(baseCode + "2"), (String)"ISBN10-2");
        Assertions.assertFalse((boolean)validator.isValid(baseCode + "3"), (String)"ISBN10-3");
        Assertions.assertFalse((boolean)validator.isValid(baseCode + "4"), (String)"ISBN10-4");
        Assertions.assertTrue((boolean)validator.isValid(baseCode + "5"), (String)"ISBN10-5");
        Assertions.assertFalse((boolean)validator.isValid(baseCode + "6"), (String)"ISBN10-6");
        Assertions.assertFalse((boolean)validator.isValid(baseCode + "7"), (String)"ISBN10-7");
        Assertions.assertFalse((boolean)validator.isValid(baseCode + "8"), (String)"ISBN10-8");
        Assertions.assertFalse((boolean)validator.isValid(baseCode + "9"), (String)"ISBN10-9");
        Assertions.assertFalse((boolean)validator.isValid(baseCode + "X"), (String)"ISBN10-X");
        baseCode = "978193011099";
        Assertions.assertFalse((boolean)validator.isValid(baseCode + "0"), (String)"ISBN13-0");
        Assertions.assertTrue((boolean)validator.isValid(baseCode + "1"), (String)"ISBN13-1");
        Assertions.assertFalse((boolean)validator.isValid(baseCode + "2"), (String)"ISBN13-2");
        Assertions.assertFalse((boolean)validator.isValid(baseCode + "3"), (String)"ISBN13-3");
        Assertions.assertFalse((boolean)validator.isValid(baseCode + "4"), (String)"ISBN13-4");
        Assertions.assertFalse((boolean)validator.isValid(baseCode + "5"), (String)"ISBN13-5");
        Assertions.assertFalse((boolean)validator.isValid(baseCode + "6"), (String)"ISBN13-6");
        Assertions.assertFalse((boolean)validator.isValid(baseCode + "7"), (String)"ISBN13-7");
        Assertions.assertFalse((boolean)validator.isValid(baseCode + "8"), (String)"ISBN13-8");
        Assertions.assertFalse((boolean)validator.isValid(baseCode + "9"), (String)"ISBN13-9");
    }

    @Test
    void testInvalidISBN10Format() {
        ISBNValidator validator = ISBNValidator.getInstance();
        Pattern pattern = Pattern.compile("^(?:(\\d{9}[0-9X])|(?:(\\d{1,5})(?:\\-|\\s)(\\d{1,7})(?:\\-|\\s)(\\d{1,6})(?:\\-|\\s)([0-9X])))$");
        for (int i = 0; i < this.invalidISBN10Format.length; ++i) {
            Assertions.assertFalse((boolean)pattern.matcher(this.invalidISBN10Format[i]).matches(), (String)("Pattern[" + i + "]=" + this.invalidISBN10Format[i]));
            Assertions.assertFalse((boolean)validator.isValidISBN10(this.invalidISBN10Format[i]), (String)("isValidISBN10[" + i + "]=" + this.invalidISBN10Format[i]));
            Assertions.assertNull((Object)validator.validateISBN10(this.invalidISBN10Format[i]), (String)("validateISBN10[" + i + "]=" + this.invalidISBN10Format[i]));
        }
    }

    @Test
    void testInvalidISBN13Format() {
        Pattern pattern = Pattern.compile("^(978|979)(?:(\\d{10})|(?:(?:\\-|\\s)(\\d{1,5})(?:\\-|\\s)(\\d{1,7})(?:\\-|\\s)(\\d{1,6})(?:\\-|\\s)([0-9])))$");
        ISBNValidator validator = ISBNValidator.getInstance();
        for (int i = 0; i < this.invalidISBN13Format.length; ++i) {
            Assertions.assertFalse((boolean)pattern.matcher(this.invalidISBN13Format[i]).matches(), (String)("Pattern[" + i + "]=" + this.invalidISBN13Format[i]));
            Assertions.assertFalse((boolean)validator.isValidISBN13(this.invalidISBN13Format[i]), (String)("isValidISBN13[" + i + "]=" + this.invalidISBN13Format[i]));
            Assertions.assertNull((Object)validator.validateISBN13(this.invalidISBN13Format[i]), (String)("validateISBN13[" + i + "]=" + this.invalidISBN13Format[i]));
        }
    }

    @Test
    void testIsValidISBN10() {
        ISBNValidator validator = ISBNValidator.getInstance();
        Assertions.assertTrue((boolean)validator.isValidISBN10("1930110995"), (String)"isValidISBN10-1");
        Assertions.assertTrue((boolean)validator.isValidISBN10("1-930110-99-5"), (String)"isValidISBN10-2");
        Assertions.assertTrue((boolean)validator.isValidISBN10("1 930110 99 5"), (String)"isValidISBN10-3");
        Assertions.assertTrue((boolean)validator.isValidISBN10("020163385X"), (String)"isValidISBN10-4");
        Assertions.assertTrue((boolean)validator.isValidISBN10("0-201-63385-X"), (String)"isValidISBN10-5");
        Assertions.assertTrue((boolean)validator.isValidISBN10("0 201 63385 X"), (String)"isValidISBN10-6");
        Assertions.assertTrue((boolean)validator.isValid("1930110995"), (String)"isValid-1");
        Assertions.assertTrue((boolean)validator.isValid("1-930110-99-5"), (String)"isValid-2");
        Assertions.assertTrue((boolean)validator.isValid("1 930110 99 5"), (String)"isValid-3");
        Assertions.assertTrue((boolean)validator.isValid("020163385X"), (String)"isValid-4");
        Assertions.assertTrue((boolean)validator.isValid("0-201-63385-X"), (String)"isValid-5");
        Assertions.assertTrue((boolean)validator.isValid("0 201 63385 X"), (String)"isValid-6");
    }

    @Test
    void testIsValidISBN13() {
        ISBNValidator validator = ISBNValidator.getInstance();
        Assertions.assertTrue((boolean)validator.isValidISBN13("9781930110991"), (String)"isValidISBN13-1");
        Assertions.assertTrue((boolean)validator.isValidISBN13("978-1-930110-99-1"), (String)"isValidISBN13-2");
        Assertions.assertTrue((boolean)validator.isValidISBN13("978 1 930110 99 1"), (String)"isValidISBN13-3");
        Assertions.assertTrue((boolean)validator.isValidISBN13("9780201633856"), (String)"isValidISBN13-4");
        Assertions.assertTrue((boolean)validator.isValidISBN13("978-0-201-63385-6"), (String)"isValidISBN13-5");
        Assertions.assertTrue((boolean)validator.isValidISBN13("978 0 201 63385 6"), (String)"isValidISBN13-6");
        Assertions.assertTrue((boolean)validator.isValid("9781930110991"), (String)"isValid-1");
        Assertions.assertTrue((boolean)validator.isValid("978-1-930110-99-1"), (String)"isValid-2");
        Assertions.assertTrue((boolean)validator.isValid("978 1 930110 99 1"), (String)"isValid-3");
        Assertions.assertTrue((boolean)validator.isValid("9780201633856"), (String)"isValid-4");
        Assertions.assertTrue((boolean)validator.isValid("978-0-201-63385-6"), (String)"isValid-5");
        Assertions.assertTrue((boolean)validator.isValid("978 0 201 63385 6"), (String)"isValid-6");
    }

    @Test
    void testNull() {
        ISBNValidator validator = ISBNValidator.getInstance();
        Assertions.assertFalse((boolean)validator.isValid(null), (String)"isValid");
        Assertions.assertFalse((boolean)validator.isValidISBN10(null), (String)"isValidISBN10");
        Assertions.assertFalse((boolean)validator.isValidISBN13(null), (String)"isValidISBN13");
        Assertions.assertNull((Object)validator.validate(null), (String)"validate");
        Assertions.assertNull((Object)validator.validateISBN10(null), (String)"validateISBN10");
        Assertions.assertNull((Object)validator.validateISBN13(null), (String)"validateISBN13");
        Assertions.assertNull((Object)validator.convertToISBN13(null), (String)"convertToISBN13");
    }

    @Test
    void testValidateISBN10() {
        ISBNValidator validator = ISBNValidator.getInstance((boolean)false);
        Assertions.assertEquals((Object)validator.validateISBN10("1930110995"), (Object)"1930110995", (String)"validateISBN10-1");
        Assertions.assertEquals((Object)validator.validateISBN10("1-930110-99-5"), (Object)"1930110995", (String)"validateISBN10-2");
        Assertions.assertEquals((Object)validator.validateISBN10("1 930110 99 5"), (Object)"1930110995", (String)"validateISBN10-3");
        Assertions.assertEquals((Object)validator.validateISBN10("020163385X"), (Object)"020163385X", (String)"validateISBN10-4");
        Assertions.assertEquals((Object)validator.validateISBN10("0-201-63385-X"), (Object)"020163385X", (String)"validateISBN10-5");
        Assertions.assertEquals((Object)validator.validateISBN10("0 201 63385 X"), (Object)"020163385X", (String)"validateISBN10-6");
        Assertions.assertEquals((Object)validator.validate("1930110995"), (Object)"1930110995", (String)"validate-1");
        Assertions.assertEquals((Object)validator.validate("1-930110-99-5"), (Object)"1930110995", (String)"validate-2");
        Assertions.assertEquals((Object)validator.validate("1 930110 99 5"), (Object)"1930110995", (String)"validate-3");
        Assertions.assertEquals((Object)validator.validate("020163385X"), (Object)"020163385X", (String)"validate-4");
        Assertions.assertEquals((Object)validator.validate("0-201-63385-X"), (Object)"020163385X", (String)"validate-5");
        Assertions.assertEquals((Object)validator.validate("0 201 63385 X"), (Object)"020163385X", (String)"validate-6");
    }

    @Test
    void testValidateISBN10Convert() {
        ISBNValidator validator = ISBNValidator.getInstance();
        Assertions.assertEquals((Object)validator.validate("1930110995"), (Object)"9781930110991", (String)"validate-1");
        Assertions.assertEquals((Object)validator.validate("1-930110-99-5"), (Object)"9781930110991", (String)"validate-2");
        Assertions.assertEquals((Object)validator.validate("1 930110 99 5"), (Object)"9781930110991", (String)"validate-3");
        Assertions.assertEquals((Object)validator.validate("020163385X"), (Object)"9780201633856", (String)"validate-4");
        Assertions.assertEquals((Object)validator.validate("0-201-63385-X"), (Object)"9780201633856", (String)"validate-5");
        Assertions.assertEquals((Object)validator.validate("0 201 63385 X"), (Object)"9780201633856", (String)"validate-6");
    }

    @Test
    void testValidateISBN13() {
        ISBNValidator validator = ISBNValidator.getInstance();
        Assertions.assertEquals((Object)validator.validateISBN13("9781930110991"), (Object)"9781930110991", (String)"validateISBN13-1");
        Assertions.assertEquals((Object)validator.validateISBN13("978-1-930110-99-1"), (Object)"9781930110991", (String)"validateISBN13-2");
        Assertions.assertEquals((Object)validator.validateISBN13("978 1 930110 99 1"), (Object)"9781930110991", (String)"validateISBN13-3");
        Assertions.assertEquals((Object)validator.validateISBN13("9780201633856"), (Object)"9780201633856", (String)"validateISBN13-4");
        Assertions.assertEquals((Object)validator.validateISBN13("978-0-201-63385-6"), (Object)"9780201633856", (String)"validateISBN13-5");
        Assertions.assertEquals((Object)validator.validateISBN13("978 0 201 63385 6"), (Object)"9780201633856", (String)"validateISBN13-6");
        Assertions.assertEquals((Object)validator.validate("9781930110991"), (Object)"9781930110991", (String)"validate-1");
        Assertions.assertEquals((Object)validator.validate("978-1-930110-99-1"), (Object)"9781930110991", (String)"validate-2");
        Assertions.assertEquals((Object)validator.validate("978 1 930110 99 1"), (Object)"9781930110991", (String)"validate-3");
        Assertions.assertEquals((Object)validator.validate("9780201633856"), (Object)"9780201633856", (String)"validate-4");
        Assertions.assertEquals((Object)validator.validate("978-0-201-63385-6"), (Object)"9780201633856", (String)"validate-5");
        Assertions.assertEquals((Object)validator.validate("978 0 201 63385 6"), (Object)"9780201633856", (String)"validate-6");
    }

    @Test
    void testValidISBN10Format() {
        Pattern pattern = Pattern.compile("^(?:(\\d{9}[0-9X])|(?:(\\d{1,5})(?:\\-|\\s)(\\d{1,7})(?:\\-|\\s)(\\d{1,6})(?:\\-|\\s)([0-9X])))$");
        for (int i = 0; i < this.validISBN10Format.length; ++i) {
            Assertions.assertTrue((boolean)pattern.matcher(this.validISBN10Format[i]).matches(), (String)("Pattern[" + i + "]=" + this.validISBN10Format[i]));
        }
    }

    @Test
    void testValidISBN13Format() {
        Pattern pattern = Pattern.compile("^(978|979)(?:(\\d{10})|(?:(?:\\-|\\s)(\\d{1,5})(?:\\-|\\s)(\\d{1,7})(?:\\-|\\s)(\\d{1,6})(?:\\-|\\s)([0-9])))$");
        for (int i = 0; i < this.validISBN13Format.length; ++i) {
            Assertions.assertTrue((boolean)pattern.matcher(this.validISBN13Format[i]).matches(), (String)("Pattern[" + i + "]=" + this.validISBN13Format[i]));
        }
    }
}

