/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpServer;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.BindException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Function;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.MapContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ScriptTest
extends JexlTestCase {
    static final String TEST1 = "src/test/scripts/test1.jexl";
    static final String TEST_ADD = "src/test/scripts/testAdd.jexl";
    static final String TEST_JSON = "src/test/scripts/httpPost.jexl";

    static HttpServer createJsonServer(Function<HttpExchange, String> responder) throws IOException {
        HttpServer server = null;
        BindException xlatest = null;
        for (int port = 8001; server == null && port < 8127; ++port) {
            try {
                server = HttpServer.create(new InetSocketAddress("localhost", port), 0);
                continue;
            }
            catch (BindException xbind) {
                xlatest = xbind;
            }
        }
        if (server == null) {
            throw xlatest;
        }
        ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)Executors.newFixedThreadPool(1);
        server.createContext("/test", httpExchange -> {
            if ("POST".equals(httpExchange.getRequestMethod())) {
                try (OutputStream outputStream = httpExchange.getResponseBody();){
                    String json = (String)responder.apply(httpExchange);
                    httpExchange.sendResponseHeaders(200, json.length());
                    outputStream.write(json.toString().getBytes());
                    outputStream.flush();
                }
            } else {
                httpExchange.sendResponseHeaders(500, 0L);
            }
        });
        server.setExecutor(threadPoolExecutor);
        server.start();
        return server;
    }

    private static String httpPostRequest(String sURL, String jsonData) throws IOException {
        URL url = new URL(sURL);
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestMethod("POST");
        con.setRequestProperty("Accept", "application/json");
        if (jsonData != null) {
            con.setRequestProperty("Content-Type", "application/json");
            con.setDoOutput(true);
            OutputStream outputStream = con.getOutputStream();
            byte[] input = jsonData.getBytes(StandardCharsets.UTF_8);
            outputStream.write(input, 0, input.length);
        }
        int responseCode = con.getResponseCode();
        InputStream inputStream = null;
        inputStream = con.getInputStream();
        StringBuilder response = new StringBuilder();
        if (inputStream != null) {
            try (BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));){
                String inputLine = "";
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
            }
        }
        return response.toString();
    }

    public ScriptTest() {
        super("ScriptTest");
    }

    @Test
    void testArgScriptFromFile() {
        File testScript = new File(TEST_ADD);
        JexlScript s = this.JEXL.createScript(testScript, new String[]{"x", "y"});
        MapContext jc = new MapContext();
        jc.set("out", (Object)System.out);
        Object result = s.execute((JexlContext)jc, new Object[]{13, 29});
        Assertions.assertNotNull((Object)result, (String)"No result");
        Assertions.assertEquals((Object)42, (Object)result, (String)"Wrong result");
    }

    @Test
    void testArgScriptFromURL() throws Exception {
        URL testUrl = new File(TEST_ADD).toURI().toURL();
        JexlScript s = this.JEXL.createScript(testUrl, new String[]{"x", "y"});
        MapContext jc = new MapContext();
        jc.set("out", (Object)System.out);
        Object result = s.execute((JexlContext)jc, new Object[]{13, 29});
        Assertions.assertNotNull((Object)result, (String)"No result");
        Assertions.assertEquals((Object)42, (Object)result, (String)"Wrong result");
    }

    @Test
    void testScriptFromFile() {
        File testScript = new File(TEST1);
        JexlScript s = this.JEXL.createScript(testScript);
        MapContext jc = new MapContext();
        jc.set("out", (Object)System.out);
        Object result = s.execute((JexlContext)jc);
        Assertions.assertNotNull((Object)result, (String)"No result");
        Assertions.assertEquals((Object)7, (Object)result, (String)"Wrong result");
    }

    @Test
    void testScriptFromURL() throws Exception {
        URL testUrl = new File(TEST1).toURI().toURL();
        JexlScript s = this.JEXL.createScript(testUrl);
        MapContext jc = new MapContext();
        jc.set("out", (Object)System.out);
        Object result = s.execute((JexlContext)jc);
        Assertions.assertNotNull((Object)result, (String)"No result");
        Assertions.assertEquals((Object)7, (Object)result, (String)"Wrong result");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testScriptJsonFromFileJava() throws IOException {
        HttpServer server = null;
        try {
            String response = "{  \"id\": 101}";
            server = ScriptTest.createJsonServer(h -> "{  \"id\": 101}");
            String url = "http:/" + server.getAddress().toString() + "/test";
            String testScript = "httpr.execute('" + url + "', null)";
            JexlScript s = this.JEXL.createScript(testScript);
            MapContext jc = new MapContext();
            jc.set("httpr", (Object)new HttpPostRequest());
            Object result = s.execute((JexlContext)jc);
            Assertions.assertNotNull((Object)result);
            Assertions.assertEquals((Object)"{  \"id\": 101}", (Object)result);
        }
        finally {
            if (server != null) {
                server.stop(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testScriptJsonFromFileJexl() throws IOException {
        HttpServer server = null;
        try {
            String response = "{  \"id\": 101}";
            server = ScriptTest.createJsonServer(h -> "{  \"id\": 101}");
            File httprFile = new File(TEST_JSON);
            JexlScript httprScript = this.JEXL.createScript(httprFile);
            MapContext jc = new MapContext();
            Object httpr = httprScript.execute((JexlContext)jc);
            JexlScript s = this.JEXL.createScript("(httpr,url)->httpr.execute(url, null)");
            String url = "http:/" + server.getAddress().toString() + "/test";
            Object result = s.execute((JexlContext)jc, new Object[]{httpr, url});
            Assertions.assertNotNull((Object)result);
            Assertions.assertEquals((Object)"{  \"id\": 101}", (Object)result);
        }
        finally {
            if (server != null) {
                server.stop(0);
            }
        }
    }

    @Test
    void testScriptUpdatesContext() {
        String jexlCode = "resultat.setCode('OK')";
        JexlExpression e = this.JEXL.createExpression("resultat.setCode('OK')");
        JexlScript s = this.JEXL.createScript("resultat.setCode('OK')");
        Tester resultatJexl = new Tester();
        MapContext jc = new MapContext();
        jc.set("resultat", (Object)resultatJexl);
        resultatJexl.setCode("");
        e.evaluate((JexlContext)jc);
        Assertions.assertEquals((Object)"OK", (Object)resultatJexl.getCode());
        resultatJexl.setCode("");
        s.execute((JexlContext)jc);
        Assertions.assertEquals((Object)"OK", (Object)resultatJexl.getCode());
    }

    @Test
    void testSimpleScript() {
        String code = "while (x < 10) x = x + 1;";
        JexlScript s = this.JEXL.createScript("while (x < 10) x = x + 1;");
        MapContext jc = new MapContext();
        jc.set("x", (Object)1);
        Object o = s.execute((JexlContext)jc);
        Assertions.assertEquals((Object)10, (Object)o, (String)"Result is wrong");
        Assertions.assertEquals((Object)"while (x < 10) x = x + 1;", (Object)s.getSourceText(), (String)"getText is wrong");
    }

    @Test
    void testSpacesScript() {
        String code = " ";
        JexlScript s = this.JEXL.createScript(" ");
        Assertions.assertNotNull((Object)s);
    }

    public static class HttpPostRequest {
        public static String execute(String url, String data) throws IOException {
            return ScriptTest.httpPostRequest(url, data);
        }
    }

    public static class Tester {
        private String code;

        public String getCode() {
            return this.code;
        }

        public void setCode(String c) {
            this.code = c;
        }
    }
}

