/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.merge.token.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.QuotingStrategy;
import org.apache.cayenne.dbsync.merge.factory.MergerTokenFactory;
import org.apache.cayenne.dbsync.merge.token.MergerToken;
import org.apache.cayenne.dbsync.merge.token.db.AbstractToDbToken;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;

public class SetPrimaryKeyToDb
extends AbstractToDbToken.Entity {
    private Collection<DbAttribute> primaryKeyOriginal;
    private Collection<DbAttribute> primaryKeyNew;
    private String detectedPrimaryKeyName;

    public SetPrimaryKeyToDb(DbEntity entity, Collection<DbAttribute> primaryKeyOriginal, Collection<DbAttribute> primaryKeyNew, String detectedPrimaryKeyName) {
        super("Set Primary Key", 100, entity);
        this.primaryKeyOriginal = primaryKeyOriginal;
        this.primaryKeyNew = primaryKeyNew;
        this.detectedPrimaryKeyName = detectedPrimaryKeyName;
    }

    @Override
    public List<String> createSql(DbAdapter adapter) {
        ArrayList<String> sqls = new ArrayList<String>();
        if (!this.primaryKeyOriginal.isEmpty()) {
            this.appendDropOriginalPrimaryKeySQL(adapter, sqls);
        }
        this.appendAddNewPrimaryKeySQL(adapter, sqls);
        return sqls;
    }

    protected void appendDropOriginalPrimaryKeySQL(DbAdapter adapter, List<String> sqls) {
        if (this.detectedPrimaryKeyName == null) {
            return;
        }
        sqls.add("ALTER TABLE " + adapter.getQuotingStrategy().quotedFullyQualifiedName(this.getEntity()) + " DROP CONSTRAINT " + this.detectedPrimaryKeyName);
    }

    protected void appendAddNewPrimaryKeySQL(DbAdapter adapter, List<String> sqls) {
        QuotingStrategy quotingStrategy = adapter.getQuotingStrategy();
        StringBuilder sql = new StringBuilder();
        sql.append("ALTER TABLE ");
        sql.append(quotingStrategy.quotedFullyQualifiedName(this.getEntity()));
        sql.append(" ADD PRIMARY KEY (");
        Iterator<DbAttribute> it = this.primaryKeyNew.iterator();
        while (it.hasNext()) {
            sql.append(quotingStrategy.quotedName(it.next()));
            if (!it.hasNext()) continue;
            sql.append(", ");
        }
        sql.append(")");
        sqls.add(sql.toString());
    }

    @Override
    public MergerToken createReverse(MergerTokenFactory factory) {
        return factory.createSetPrimaryKeyToModel(this.getEntity(), this.primaryKeyNew, this.primaryKeyOriginal, this.detectedPrimaryKeyName);
    }
}

