/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.select;

import java.util.List;
import org.apache.cayenne.access.sqlbuilder.ExpressionNodeBuilder;
import org.apache.cayenne.access.sqlbuilder.JoinNodeBuilder;
import org.apache.cayenne.access.sqlbuilder.NodeBuilder;
import org.apache.cayenne.access.sqlbuilder.SQLBuilder;
import org.apache.cayenne.access.sqlbuilder.sqltree.Node;
import org.apache.cayenne.access.translator.select.TableTreeNode;
import org.apache.cayenne.access.translator.select.TranslationStage;
import org.apache.cayenne.access.translator.select.TranslatorContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.parser.ASTDbPath;
import org.apache.cayenne.exp.parser.ASTPath;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbJoin;

class TableTreeStage
implements TranslationStage {
    TableTreeStage() {
    }

    @Override
    public void perform(TranslatorContext context) {
        context.getTableTree().visit(node -> {
            NodeBuilder tableNode = SQLBuilder.table(node.getEntity()).as(node.getTableAlias());
            if (node.getRelationship() != null) {
                tableNode = this.getJoin(node, tableNode).on(this.getJoinExpression(context, node));
            }
            context.getSelectBuilder().from(tableNode);
        });
    }

    private JoinNodeBuilder getJoin(TableTreeNode node, NodeBuilder table) {
        switch (node.getJoinType()) {
            case INNER: {
                return SQLBuilder.join(table);
            }
            case LEFT_OUTER: {
                return SQLBuilder.leftJoin(table);
            }
        }
        throw new IllegalArgumentException("Unsupported join type: " + (Object)((Object)node.getJoinType()));
    }

    private NodeBuilder getJoinExpression(TranslatorContext context, TableTreeNode node) {
        List<DbJoin> joins = node.getRelationship().getJoins();
        ExpressionNodeBuilder expressionNodeBuilder = null;
        String sourceAlias = context.getTableTree().aliasForPath(node.getAttributePath().getParent());
        for (DbJoin dbJoin : joins) {
            DbAttribute src = dbJoin.getSource();
            DbAttribute dst = dbJoin.getTarget();
            ExpressionNodeBuilder joinExp = SQLBuilder.table(sourceAlias).column(src).eq(SQLBuilder.table(node.getTableAlias()).column(dst));
            if (expressionNodeBuilder != null) {
                expressionNodeBuilder = expressionNodeBuilder.and(joinExp);
                continue;
            }
            expressionNodeBuilder = joinExp;
        }
        expressionNodeBuilder = TableTreeStage.appendQualifier(expressionNodeBuilder, context, node, node.getEntity().getQualifier());
        expressionNodeBuilder = TableTreeStage.appendQualifier(expressionNodeBuilder, context, node, node.getAdditionalQualifier());
        return expressionNodeBuilder;
    }

    private static ExpressionNodeBuilder appendQualifier(ExpressionNodeBuilder joinBuilder, TranslatorContext context, TableTreeNode node, Expression dbQualifier) {
        if (dbQualifier == null) {
            return joinBuilder;
        }
        dbQualifier = TableTreeStage.translateToDbPath(node, dbQualifier);
        context.getTableTree().setActiveNode(node);
        Node translatedQualifier = context.getQualifierTranslator().translate(dbQualifier);
        context.getTableTree().setActiveNode(null);
        return joinBuilder.and(() -> translatedQualifier);
    }

    static Expression translateToDbPath(TableTreeNode node, Expression dbQualifier) {
        String pathToRoot = node.getAttributePath().getPath();
        dbQualifier = dbQualifier.transform(input -> {
            if (input instanceof ASTPath) {
                String path = ((ASTPath)input).getPath();
                if (!pathToRoot.isEmpty()) {
                    path = "__current_join_table." + path;
                }
                return new ASTDbPath(path);
            }
            return input;
        });
        return dbQualifier;
    }
}

