/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spi;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;

public interface BrowsableEndpoint
extends Endpoint {
    public int getBrowseLimit();

    public void setBrowseLimit(int var1);

    default public BrowseStatus getBrowseStatus(int limit) {
        List<Exchange> list = this.getExchanges();
        long ts = 0L;
        long ts2 = 0L;
        if (!list.isEmpty()) {
            ts = list.get(0).getMessage().getHeader("CamelMessageTimestamp", 0L, Long.TYPE);
            ts2 = list.get(list.size() - 1).getMessage().getHeader("CamelMessageTimestamp", 0L, Long.TYPE);
        }
        return new BrowseStatus(list.size(), ts, ts2);
    }

    public List<Exchange> getExchanges();

    default public List<Exchange> getExchanges(int limit, Predicate filter) {
        List<Exchange> answer = this.getExchanges();
        if (filter != null) {
            answer = answer.stream().filter(filter).collect(Collectors.toList());
        }
        if (limit > 0) {
            answer = answer.stream().limit(limit).toList();
        }
        return answer;
    }

    public record BrowseStatus(int size, long firstTimestamp, long lastTimestamp) {
    }
}

