/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.spring.context.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.xbean.spring.context.impl.DefaultProperty;
import org.apache.xbean.spring.context.impl.MappingMetaData;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.AbstractBeanDefinition;

public class NamedConstructorArgs {
    private Map defaultValues = new HashMap();
    private static final Map DEFAULT_VALUE;

    public List getDefaultValues() {
        LinkedList<DefaultProperty> values = new LinkedList<DefaultProperty>();
        for (Map.Entry entry : this.defaultValues.entrySet()) {
            PropertyKey key = (PropertyKey)entry.getKey();
            Object value = entry.getValue();
            values.add(new DefaultProperty(key.name, key.type, value));
        }
        return values;
    }

    public void setDefaultValues(List defaultValues) {
        this.defaultValues.clear();
        Iterator iterator = defaultValues.iterator();
        while (iterator.hasNext()) {
            this.addDefaultValue((DefaultProperty)iterator.next());
        }
    }

    public void addDefaultValue(String name, Class type, Object value) {
        this.defaultValues.put(new PropertyKey(name, type), value);
    }

    private void addDefaultValue(DefaultProperty defaultProperty) {
        this.defaultValues.put(new PropertyKey(defaultProperty.getName(), defaultProperty.getType()), defaultProperty.getValue());
    }

    public void processParameters(BeanDefinitionHolder definitionHolder, MappingMetaData metadata) throws BeansException {
        if (!(definitionHolder.getBeanDefinition() instanceof AbstractBeanDefinition)) {
            return;
        }
        AbstractBeanDefinition beanDefinition = (AbstractBeanDefinition)definitionHolder.getBeanDefinition();
        ConstructorArgumentValues constructorArgumentValues = beanDefinition.getConstructorArgumentValues();
        if (constructorArgumentValues.getArgumentCount() > 0) {
            return;
        }
        ConstructionInfo constructionInfo = this.selectConstructionMethod(beanDefinition, metadata);
        if (constructionInfo == null) {
            return;
        }
        MutablePropertyValues propertyValues = beanDefinition.getPropertyValues();
        String[] parameterNames = constructionInfo.parameterNames;
        Class[] parameterTypes = constructionInfo.parameterTypes;
        for (int i2 = 0; i2 < parameterNames.length; ++i2) {
            String parameterName = parameterNames[i2];
            Class parameterType = parameterTypes[i2];
            PropertyValue propertyValue = propertyValues.getPropertyValue(parameterName);
            if (propertyValue != null) {
                propertyValues.removePropertyValue(parameterName);
                constructorArgumentValues.addIndexedArgumentValue(i2, propertyValue.getValue(), parameterType.getName());
                continue;
            }
            Object defaultValue = this.defaultValues.get(new PropertyKey(parameterName, parameterType));
            if (defaultValue == null) {
                defaultValue = DEFAULT_VALUE.get(parameterType);
            }
            if (defaultValue instanceof FactoryBean) {
                try {
                    defaultValue = ((FactoryBean)defaultValue).getObject();
                }
                catch (Exception e) {
                    throw new FatalBeanException("Unable to get object value from bean factory", e);
                }
            }
            constructorArgumentValues.addIndexedArgumentValue(i2, defaultValue, parameterType.getName());
        }
    }

    private ConstructionInfo selectConstructionMethod(AbstractBeanDefinition beanDefinition, MappingMetaData metadata) {
        Class<?> beanClass = beanDefinition.getBeanClass();
        HashSet<String> definedProperties = new HashSet<String>();
        PropertyValue[] values = beanDefinition.getPropertyValues().getPropertyValues();
        for (int i2 = 0; i2 < values.length; ++i2) {
            definedProperties.add(values[i2].getName());
        }
        if (beanDefinition.getFactoryMethodName() != null) {
            return this.selectFactory(beanClass, beanDefinition, metadata, definedProperties);
        }
        return this.selectConstructor(beanClass, metadata, definedProperties);
    }

    private ConstructionInfo selectFactory(Class beanClass, AbstractBeanDefinition beanDefinition, MappingMetaData metadata, Set definedProperties) {
        String factoryMethodName = beanDefinition.getFactoryMethodName();
        Method[] methods = beanClass.getMethods();
        ArrayList<Method> factoryMethods = new ArrayList<Method>(methods.length);
        for (int i2 = 0; i2 < methods.length; ++i2) {
            Method method = methods[i2];
            if (!method.getName().equals(factoryMethodName)) continue;
            factoryMethods.add(method);
        }
        Collections.sort(factoryMethods, new ArgLengthComparator());
        for (Method factoryMethod : factoryMethods) {
            if (!metadata.isDefaultFactoryMethod(beanClass, factoryMethod)) continue;
            return new ConstructionInfo(beanClass, factoryMethod, metadata);
        }
        for (Method factoryMethod : factoryMethods) {
            ConstructionInfo constructionInfo = new ConstructionInfo(beanClass, factoryMethod, metadata);
            if (!this.isUsableConstructor(constructionInfo, definedProperties)) continue;
            return constructionInfo;
        }
        return null;
    }

    private ConstructionInfo selectConstructor(Class beanClass, MappingMetaData metadata, Set definedProperties) {
        ArrayList constructors = new ArrayList(Arrays.asList(beanClass.getConstructors()));
        Collections.sort(constructors, new ArgLengthComparator());
        for (Constructor constructor : constructors) {
            if (!metadata.isDefaultConstructor(constructor)) continue;
            return new ConstructionInfo(constructor, metadata);
        }
        for (Constructor constructor : constructors) {
            ConstructionInfo constructionInfo = new ConstructionInfo(constructor, metadata);
            if (!this.isUsableConstructor(constructionInfo, definedProperties)) continue;
            return constructionInfo;
        }
        return null;
    }

    private boolean isUsableConstructor(ConstructionInfo constructionInfo, Set definedProperties) {
        String[] parameterNames = constructionInfo.parameterNames;
        if (parameterNames == null) {
            return false;
        }
        Class[] parameterTypes = constructionInfo.parameterTypes;
        for (int i2 = 0; i2 < parameterNames.length; ++i2) {
            String parameterName = parameterNames[i2];
            Class parameterType = parameterTypes[i2];
            if (definedProperties.contains(parameterName) || this.defaultValues.containsKey(new PropertyKey(parameterName, parameterType))) continue;
            return false;
        }
        return true;
    }

    static {
        HashMap<Class<Comparable<Boolean>>, Comparable<Boolean>> temp = new HashMap<Class<Comparable<Boolean>>, Comparable<Boolean>>();
        temp.put(Boolean.TYPE, Boolean.FALSE);
        temp.put(Byte.TYPE, new Byte(0));
        temp.put(Character.TYPE, new Character('\u0000'));
        temp.put(Short.TYPE, new Short(0));
        temp.put(Integer.TYPE, new Integer(0));
        temp.put(Long.TYPE, new Long(0L));
        temp.put(Float.TYPE, new Float(0.0f));
        temp.put(Double.TYPE, new Double(0.0));
        DEFAULT_VALUE = Collections.unmodifiableMap(temp);
    }

    private static class PropertyKey {
        private final String name;
        private final Class type;

        public PropertyKey(String name, Class type) {
            this.name = name;
            this.type = type;
        }

        public boolean equals(Object object) {
            if (!(object instanceof PropertyKey)) {
                return false;
            }
            PropertyKey defaultProperty = (PropertyKey)object;
            return this.name.equals(defaultProperty.name) && this.type.equals(this.type);
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + this.name.hashCode();
            result = 37 * result + this.type.hashCode();
            return result;
        }

        public String toString() {
            return "[" + this.name + " " + this.type + "]";
        }
    }

    private static class ArgLengthComparator
    implements Comparator {
        private ArgLengthComparator() {
        }

        public int compare(Object o1, Object o2) {
            return this.getArgLength(o2) - this.getArgLength(o1);
        }

        private int getArgLength(Object object) {
            if (object instanceof Method) {
                return ((Method)object).getParameterTypes().length;
            }
            return ((Constructor)object).getParameterTypes().length;
        }
    }

    private class ConstructionInfo {
        private final Class[] parameterTypes;
        private final String[] parameterNames;

        public ConstructionInfo(Constructor constructor, MappingMetaData metadata) {
            this.parameterTypes = constructor.getParameterTypes();
            String[] names = metadata.getParameterNames(constructor);
            int expectedParameterCount = this.parameterTypes.length;
            if (names != null && names.length != expectedParameterCount) {
                throw new FatalBeanException("Excpected " + expectedParameterCount + " parameter names for constructor but only got " + names.length + ": " + constructor.toString());
            }
            if (expectedParameterCount == 0) {
                names = new String[]{};
            }
            this.parameterNames = names;
        }

        public ConstructionInfo(Class beanClass, Method factoryMethod, MappingMetaData metadata) {
            this.parameterTypes = factoryMethod.getParameterTypes();
            String[] names = metadata.getParameterNames(beanClass, factoryMethod);
            int expectedParameterCount = this.parameterTypes.length;
            if (names != null && names.length != expectedParameterCount) {
                throw new FatalBeanException("Excpected " + expectedParameterCount + " parameter names for factory method but only got " + names.length + ": " + factoryMethod.toString());
            }
            if (expectedParameterCount == 0) {
                names = new String[]{};
            }
            this.parameterNames = names;
        }
    }
}

